/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.taurus.text.SearchResult;
import com.tradevan.taurus.text.TextException;
import com.tradevan.taurus.text.TextProcessor;
import com.tradevan.taurus.text.TextReader;
import com.tradevan.taurus.text.TextRuntimeException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextSearcher
extends TextProcessor {
    private boolean regularEnable = false;
    private String target;
    private Pattern pattern;
    private boolean caseSensitive = false;
    private boolean trimValue = false;
    private String source;
    private TextReader reader;

    public TextSearcher() {
    }

    public TextSearcher(TextReader reader) {
        this.reader = reader;
    }

    public TextSearcher(TextReader reader, String searchStr) {
        this.reader = reader;
        this.target = searchStr;
    }

    public TextReader getReader() {
        return this.reader;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public void init(Properties prop) {
        if (prop != null) {
            if ("true".equals(prop.getProperty("case-sensitive"))) {
                this.caseSensitive = true;
            }
            if ("true".equals(prop.getProperty("trim-value"))) {
                this.trimValue = true;
            }
            if ("true".equals(prop.getProperty("regular-enable"))) {
                this.regularEnable = true;
            }
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegularEnable() {
        return this.regularEnable;
    }

    public boolean isTrimValue() {
        return this.trimValue;
    }

    public SearchResult[] next() throws TextException {
        this.validate(this.target);
        return this.search(this.target);
    }

    public SearchResult[] search(String target) throws TextException {
        this.validate(target);
        SearchResult[] temp = null;
        while (this.reader.nextLine() != null) {
            temp = this.regularEnable ? this.searchByRex(this.reader.currentLine(), target, this.caseSensitive, this.trimValue) : this.search(this.reader.currentLine(), target, this.caseSensitive, this.trimValue);
            if (temp == null || temp.length == 0) continue;
            return temp;
        }
        return null;
    }

    protected SearchResult[] search(String str, String target, boolean caseSensitive, boolean trimValue) {
        this.source = str;
        String tmp = null;
        String tmpTarget = null;
        if (caseSensitive) {
            tmp = str;
            tmpTarget = target;
        } else {
            tmp = str.toUpperCase();
            tmpTarget = target.toUpperCase();
        }
        ArrayList<SearchResult> list = new ArrayList<SearchResult>();
        SearchResult[] result = null;
        int fromIndex = 0;
        int end = 0;
        SearchResult temp = null;
        while ((fromIndex = tmp.indexOf(tmpTarget, fromIndex)) != -1) {
            end = fromIndex + tmpTarget.length();
            temp = new SearchResult();
            temp.setStart(fromIndex);
            temp.setEnd(end);
            temp.setLine(this.reader.currentLineNum);
            temp.setSource(str);
            if (trimValue) {
                temp.setTarget(str.substring(fromIndex, end).trim());
            } else {
                temp.setTarget(str.substring(fromIndex, end));
            }
            list.add(temp);
            fromIndex = end;
        }
        result = new SearchResult[list.size()];
        result = list.toArray(result);
        return result;
    }

    public SearchResult[] searchAll() throws TextException {
        this.validate(this.target);
        ArrayList<SearchResult[]> list = new ArrayList<SearchResult[]>();
        int totalNum = 0;
        while (this.reader.nextLine() != null) {
            SearchResult[] temp = null;
            temp = this.regularEnable ? this.searchByRex(this.reader.currentLine(), this.target, this.caseSensitive, this.trimValue) : this.search(this.reader.currentLine(), this.target, this.caseSensitive, this.trimValue);
            if (temp == null || temp.length == 0) continue;
            totalNum += temp.length;
            list.add(temp);
        }
        SearchResult[] result = new SearchResult[totalNum];
        int position = 0;
        int i = 0;
        while (i < list.size()) {
            SearchResult[] temp = (SearchResult[])list.get(i);
            System.arraycopy(temp, 0, result, position, temp.length);
            position += temp.length;
            ++i;
        }
        return result;
    }

    public SearchResult[] searchAll(String target) throws TextException {
        this.validate(target);
        ArrayList<SearchResult[]> list = new ArrayList<SearchResult[]>();
        int totalNum = 0;
        while (this.reader.nextLine() != null) {
            SearchResult[] temp = null;
            temp = this.regularEnable ? this.searchByRex(this.reader.currentLine(), target, this.caseSensitive, this.trimValue) : this.search(this.reader.currentLine(), target, this.caseSensitive, this.trimValue);
            if (temp == null || temp.length == 0) continue;
            totalNum += temp.length;
            list.add(temp);
        }
        SearchResult[] result = new SearchResult[totalNum];
        int position = 0;
        int i = 0;
        while (i < list.size()) {
            SearchResult[] temp = (SearchResult[])list.get(i);
            System.arraycopy(temp, 0, result, position, temp.length);
            position += temp.length;
            ++i;
        }
        return result;
    }

    protected SearchResult[] searchByRex(String str, String regex, boolean caseSensitive, boolean trimValue) {
        this.source = str;
        ArrayList<SearchResult> list = new ArrayList<SearchResult>();
        SearchResult[] result = null;
        this.pattern = !caseSensitive ? Pattern.compile(regex, 66) : Pattern.compile(regex);
        Matcher pm = this.pattern.matcher(str);
        SearchResult temp = null;
        while (pm.find()) {
            String cs = pm.group();
            temp = new SearchResult();
            temp.setStart(pm.start());
            temp.setEnd(pm.end());
            if (trimValue) {
                temp.setTarget(cs.trim());
            } else {
                temp.setTarget(cs);
            }
            temp.setSource(str);
            temp.setLine(this.reader.currentLineNum);
            list.add(temp);
            if (pm.end() == str.length()) break;
        }
        result = new SearchResult[list.size()];
        result = list.toArray(result);
        return result;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setReader(TextReader reader) {
        this.reader = reader;
    }

    public void setRegularEnable(boolean regularEnable) {
        this.regularEnable = regularEnable;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTrimValue(boolean trim) {
        this.trimValue = trim;
    }

    protected void validate(String target) {
        if (this.reader == null) {
            throw new TextRuntimeException("TextReader is null! Please set a TextReader to TextParser!");
        }
        if (target == null) {
            throw new TextRuntimeException("Search target can't be null!");
        }
        if (target.equals("")) {
            throw new TextRuntimeException("Search target can't be empty!");
        }
        this.target = target;
    }
}

