/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.io.StreamUtil;
import com.tradevan.commons.util.LogUtil;
import com.tradevan.taurus.text.TextCondition;
import com.tradevan.taurus.text.TextException;
import com.tradevan.taurus.text.TextIO;
import com.tradevan.taurus.text.TextRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class TextReader
extends TextIO {
    protected String currentCharSet;
    private static final int _BUFFER_SIZE = 4096;
    protected BufferedReader reader = null;
    protected String currentLine = "";
    protected long currentLineNum = 0L;

    public TextReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 4096);
    }

    public TextReader(InputStream is) {
        if (this.charset != null) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(is, this.charset), 4096);
            }
            catch (Exception e) {
                this.reader = new BufferedReader(new InputStreamReader(is), 4096);
            }
        } else {
            this.reader = new BufferedReader(new InputStreamReader(is), 4096);
        }
    }

    public TextReader(InputStream is, String charset) throws UnsupportedEncodingException {
        this.currentCharSet = charset;
        this.reader = new BufferedReader(new InputStreamReader(is, charset), 4096);
    }

    public TextReader(String file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public TextReader(String file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), charset);
    }

    public TextReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public TextReader(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), charset);
    }

    public String currentLine() {
        return this.currentLine;
    }

    public long currentLineNum() {
        return this.currentLineNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextLine() throws TextException {
        String line = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                line = this.readLine(true);
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readLines(int n) throws TextException {
        if (n < 1) {
            throw new TextRuntimeException("The number of skipped line must be greater than 0!");
        }
        ArrayList<String> lineList = new ArrayList<String>(n);
        try {
            String line = null;
            Object object = this.lock;
            synchronized (object) {
                int i = 0;
                while (i < n) {
                    line = this.readLine(true);
                    if (line == null) break;
                    lineList.add(line);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readLinesUntil(TextCondition condition) throws TextException {
        ArrayList<String> lineList = new ArrayList<String>(10);
        try {
            String line = null;
            Object object = this.lock;
            synchronized (object) {
                while ((line = this.readLine(true)) != null) {
                    if (condition != null && condition.accept(line)) break;
                    lineList.add(line);
                }
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int skipLine(int n) {
        if (n < 1) {
            throw new TextRuntimeException("The number of skipped line must be greater than 0!");
        }
        int actual = 0;
        try {
            Object object = this.lock;
            synchronized (object) {
                while (actual < n && this.readLine(false) != null) {
                    ++actual;
                }
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)e, (Throwable)e);
        }
        return actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int skipLineUntil(TextCondition condition) {
        if (condition == null) {
            throw new TextRuntimeException("TextCondition parameter is null!");
        }
        int actual = 0;
        try {
            Object object = this.lock;
            synchronized (object) {
                String line = null;
                while ((line = this.readLine(false)) != null) {
                    ++actual;
                    if (!condition.accept(line)) continue;
                }
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)e, (Throwable)e);
        }
        return actual;
    }

    public void close() {
        StreamUtil.close((Reader)this.reader);
    }

    public Reader getReader() {
        return this.reader;
    }

    protected String readLine(boolean useProcessor) throws IOException {
        if (useProcessor && this.processor != null) {
            while ((this.currentLine = this.reader.readLine()) != null) {
                ++this.currentLineNum;
                this.currentLine = this.processor.processToLine(this.currentLine);
                if (this.currentLine == null) {
                    continue;
                }
                break;
            }
        } else {
            this.currentLine = this.reader.readLine();
            ++this.currentLineNum;
        }
        if (this.currentLine == null) {
            this.currentLineNum = -1L;
        }
        return this.currentLine;
    }

    public String getCurrentCharSet() {
        return this.currentCharSet;
    }

    public void setCurrentCharSet(String currentCharSet) {
        this.currentCharSet = currentCharSet;
    }
}

