/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.collection.DataList;
import com.tradevan.commons.collection.DataObject;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.taurus.text.TextElement;
import com.tradevan.taurus.text.TextException;
import com.tradevan.taurus.text.TextProcessor;
import com.tradevan.taurus.text.TextReader;
import com.tradevan.taurus.text.TextRuntimeException;
import java.util.Map;
import java.util.Properties;

public class TextParser
extends TextProcessor {
    public static final String UNIT_BYTE = "byte";
    public static final String UNIT_CHAR = "char";
    private static final int _BYTE_MODE = 1;
    private static final int _CHAR_MODE = 2;
    private TextReader reader;
    private TextElement[] textElements;
    private boolean formatValue = false;
    private boolean trimValue = true;
    private int unitMode = 1;

    public TextParser() {
    }

    public TextParser(TextReader reader) {
        this.reader = reader;
    }

    public TextParser(TextReader reader, TextElement[] textElements) {
        this.reader = reader;
        this.textElements = textElements;
    }

    public void init(Properties prop) {
        if (prop != null) {
            String s;
            if ("true".equals(prop.getProperty("format-value"))) {
                this.formatValue = true;
            }
            if ("true".equals(prop.getProperty("trim-value"))) {
                this.trimValue = true;
            }
            if (!StringUtil.isEmpty((String)(s = prop.getProperty("length-unit")))) {
                this.setLengthUnit(s);
            }
        }
    }

    public int parse(String str, TextElement[] elements, DataObject obj) {
        int strLength;
        if (ArrayUtil.isEmpty((Object)elements) || StringUtil.isEmpty((String)str)) {
            return -1;
        }
        int pos = 0;
        byte[] strBytes = null;
        if (this.unitMode == 1) {
            strBytes = str.getBytes();
            strLength = strBytes.length;
        } else {
            strLength = str.length();
        }
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getId();
            int elementLen = elements[i].getLength();
            if (strLength - pos < elementLen) break;
            String value = this.unitMode == 1 ? new String(strBytes, pos, elementLen) : str.substring(pos, pos + elementLen);
            if (this.trimValue) {
                value = value.trim();
            }
            if (this.formatValue) {
                value = elements[i].format(value);
            }
            pos += elementLen;
            if (!StringUtil.isEmpty((String)id) && obj != null) {
                obj.setValue(id, (Object)value);
            }
            ++i;
        }
        return pos;
    }

    public DataObject parse(String str, TextElement[] elements, String separator) {
        DataObject obj = new DataObject();
        if (StringUtil.isEmpty((String)str) || StringUtil.isEmpty((String)separator)) {
            return obj;
        }
        int sepLength = separator.length();
        int start = 0;
        int strPos = 0;
        int i = 0;
        while (i < elements.length) {
            strPos = str.indexOf(separator, start);
            if (strPos == -1) break;
            String id = elements[i].getId();
            if (!StringUtil.isEmpty((String)id)) {
                String value = str.substring(start, strPos);
                if (this.trimValue) {
                    value = value.trim();
                }
                if (this.formatValue) {
                    value = elements[i].format(value);
                }
                obj.setValue(id, (Object)value);
            }
            start = strPos + sepLength;
            ++i;
        }
        return obj;
    }

    public DataObject parse(String str, TextElement[] elements) {
        DataObject obj = new DataObject();
        this.parse(str, elements, obj);
        return obj;
    }

    public DataList parse(String str, Map map) {
        DataList list = new DataList();
        if (StringUtil.isEmpty((String)str) || map == null || map.isEmpty()) {
            return list;
        }
        byte[] strBytes = this.unitMode == 1 ? str.getBytes() : null;
        int pos = 0;
        int len = 0;
        String remainedStr = str;
        Object[] key = map.keySet().toArray();
        while (remainedStr != null || !remainedStr.equals("")) {
            DataObject obj = null;
            int index = 0;
            int i = 0;
            while (i < key.length) {
                if (remainedStr.startsWith(key[i].toString())) {
                    TextElement[] elements = (TextElement[])map.get(key[i]);
                    obj = new DataObject();
                    len = this.parse(remainedStr, elements, obj);
                    break;
                }
                ++index;
                ++i;
            }
            if (index == key.length || len == -1) break;
            list.add(obj);
            remainedStr = this.unitMode == 1 ? new String(strBytes, pos, strBytes.length - pos) : str.substring(pos += len);
            len = 0;
        }
        return list;
    }

    public DataObject parseNext() throws TextException {
        return this.parseNext(this.textElements);
    }

    public DataObject parseNext(TextElement[] elements) throws TextException {
        if (this.reader == null) {
            throw new TextRuntimeException("No reader is found!");
        }
        String line = this.reader.nextLine();
        if (line != null) {
            return this.parse(line, elements);
        }
        return null;
    }

    public DataList parseNext(Map map) throws TextException {
        if (this.reader == null) {
            throw new TextRuntimeException("TextReader is null! Please set a TextReader to TextParser!");
        }
        String line = this.reader.nextLine();
        if (line != null) {
            return this.parse(line, map);
        }
        return null;
    }

    public DataList parse() throws TextException {
        if (this.reader == null) {
            throw new TextRuntimeException("TextReader is null! Please set a TextReader to TextParser!");
        }
        DataList list = new DataList();
        while (this.reader.nextLine() != null) {
            DataObject obj = new DataObject();
            int i = this.parse(this.reader.currentLine(), this.textElements, obj);
            if (i == -1) continue;
            list.add(obj);
        }
        return list;
    }

    public void setFormatValue(boolean format) {
        this.formatValue = format;
    }

    public boolean isFormatValue() {
        return this.formatValue;
    }

    public void setTrimValue(boolean trim) {
        this.trimValue = trim;
    }

    public boolean isTrimValue() {
        return this.trimValue;
    }

    public TextElement[] getTextElements() {
        return this.textElements;
    }

    public void setTextElements(TextElement[] textElements) {
        this.textElements = textElements;
    }

    public TextReader getReader() {
        return this.reader;
    }

    public void setReader(TextReader reader) {
        this.reader = reader;
    }

    public void setLengthUnit(String unit) {
        if (UNIT_CHAR.equalsIgnoreCase(unit)) {
            this.unitMode = 2;
        } else if (UNIT_BYTE.equalsIgnoreCase(unit)) {
            this.unitMode = 1;
        } else {
            throw new TextRuntimeException("unit must is one of UNIT_CHAR or UNIT_BYTE!");
        }
    }

    public String getLengthUnit() {
        return this.unitMode == 1 ? UNIT_BYTE : UNIT_CHAR;
    }
}

