/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.lang.ClassUtil;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.taurus.text.TextConfig;
import com.tradevan.taurus.text.TextIO;
import com.tradevan.taurus.text.TextProcessor;
import com.tradevan.taurus.text.TextReader;
import com.tradevan.taurus.text.TextRuntimeException;
import com.tradevan.taurus.text.TextWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class TextFactory {
    private static TextFactory me = null;
    private TextConfig config = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public TextFactory(TextConfig config) {
        if (config == null) {
            throw new TextRuntimeException("TextConfig is null!");
        }
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextFactory getInstance() {
        if (me != null) return me;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.tradevan.taurus.text.TextFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (me != null) return me;
            me = new TextFactory(TextConfig.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    public TextReader getReader(String file) throws FileNotFoundException {
        return this.getReader(new FileInputStream(file), null);
    }

    public TextReader getReader(File file) throws FileNotFoundException {
        return this.getReader(new FileInputStream(file), null);
    }

    public TextReader getReader(InputStream is) {
        return this.getReader(is, null);
    }

    public TextReader getReader(InputStream is, String charset) {
        TextReader reader = null;
        String readerId = this.config.getDefaultReaderId();
        if (!StringUtil.isEmpty((String)readerId)) {
            reader = this.getReader(readerId, is, charset);
        } else {
            Object[] param;
            Class[] paramClass;
            if (charset != null) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.io.InputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                paramClass = classArray;
                param = new Object[]{is, charset};
            } else {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.io.InputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                paramClass = classArray;
                param = new Object[]{is};
            }
            reader = (TextReader)ClassUtil.newInstance((String)"com.tradevan.taurus.text.TextReader", (Class[])paramClass, (Object[])param);
        }
        return reader;
    }

    public TextReader getReader(String readerId, String file) throws FileNotFoundException {
        return this.getReader(readerId, new FileInputStream(file), null);
    }

    public TextReader getReader(String readerId, File file) throws FileNotFoundException {
        return this.getReader(readerId, new FileInputStream(file), null);
    }

    public TextReader getReader(String readerId, InputStream is) {
        return this.getReader(readerId, is, null);
    }

    public TextReader getReader(String readerId, InputStream is, String charset) {
        Object[] param;
        Class[] paramClass;
        String s;
        String readerClass = this.config.getReaderClass(readerId);
        if (StringUtil.isEmpty((String)readerClass)) {
            throw new TextRuntimeException(String.valueOf(readerId) + " TextReader is undefined!");
        }
        if (charset == null && !StringUtil.isEmpty((String)(s = this.config.getReaderProperty(readerId, "charset")))) {
            charset = s;
        }
        if (charset != null) {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            paramClass = classArray;
            param = new Object[]{is, charset};
        } else {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            paramClass = classArray;
            param = new Object[]{is};
        }
        TextReader reader = (TextReader)ClassUtil.newInstance((String)readerClass, (Class[])paramClass, (Object[])param);
        if (reader == null) {
            throw new TextRuntimeException("Faile to new instance for " + readerClass + " class");
        }
        reader.init(this.config.getReaderProperties(readerId));
        return reader;
    }

    public TextReader getReader(String readerId, Reader reader) {
        String readerClass = this.config.getReaderClass(readerId);
        if (StringUtil.isEmpty((String)readerClass)) {
            throw new TextRuntimeException(String.valueOf(readerId) + " TextReader is undefined!");
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.io.Reader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        TextReader textReader = (TextReader)ClassUtil.newInstance((String)readerClass, (Class[])classArray, (Object[])new Reader[]{reader});
        if (textReader == null) {
            throw new TextRuntimeException("Faile to new instance for " + readerClass + " class");
        }
        textReader.init(this.config.getReaderProperties(readerId));
        return textReader;
    }

    public TextWriter getWriter(String file) throws FileNotFoundException {
        return this.getWriter(new FileOutputStream(file), null);
    }

    public TextWriter getWriter(File file) throws FileNotFoundException {
        return this.getWriter(new FileOutputStream(file), null);
    }

    public TextWriter getWriter(String file, String charset) throws FileNotFoundException {
        return this.getWriter(new FileOutputStream(file), charset);
    }

    public TextWriter getWriter(File file, String charset) throws FileNotFoundException {
        return this.getWriter(new FileOutputStream(file), charset);
    }

    public TextWriter getWriter(OutputStream is, String charset) {
        TextWriter writer = null;
        String writerId = this.config.getDefaultWriterId();
        if (!StringUtil.isEmpty((String)writerId)) {
            writer = this.getWriter(writerId, is, charset);
        } else {
            Object[] param;
            Class[] paramClass;
            if (charset != null) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.io.OutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                paramClass = classArray;
                param = new Object[]{is, charset};
            } else {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.io.OutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                paramClass = classArray;
                param = new Object[]{is};
            }
            writer = (TextWriter)ClassUtil.newInstance((String)"com.tradevan.taurus.text.TextWriter", (Class[])paramClass, (Object[])param);
        }
        return writer;
    }

    public TextWriter getWriter(String writerId, OutputStream is, String charset) {
        Object[] param;
        Class[] paramClass;
        String s;
        String writerClass = this.config.getWriterClass(writerId);
        if (StringUtil.isEmpty((String)writerClass)) {
            throw new TextRuntimeException(String.valueOf(writerId) + " TextWriter is undefined!");
        }
        if (charset == null && !StringUtil.isEmpty((String)(s = this.config.getWriterProperty(writerId, "charset")))) {
            charset = s;
        }
        if (charset != null) {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.io.OutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            paramClass = classArray;
            param = new Object[]{is, charset};
        } else {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.io.OutputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            paramClass = classArray;
            param = new Object[]{is};
        }
        TextWriter writer = (TextWriter)ClassUtil.newInstance((String)writerClass, (Class[])paramClass, (Object[])param);
        if (writer == null) {
            throw new TextRuntimeException("Fail to new instance for " + writerClass + " class");
        }
        writer.init(this.config.getWriterProperties(writerId));
        return writer;
    }

    public TextWriter getWriter(String writerId, Writer writer) {
        String writerClass = this.config.getWriterClass(writerId);
        if (StringUtil.isEmpty((String)writerClass)) {
            throw new TextRuntimeException(String.valueOf(writerId) + " TextWriter is undefined!");
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.io.Writer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        TextWriter textWriter = (TextWriter)ClassUtil.newInstance((String)writerClass, (Class[])classArray, (Object[])new Writer[]{writer});
        if (textWriter == null) {
            throw new TextRuntimeException("Fail to new instance for " + writerClass + " class");
        }
        textWriter.init(this.config.getWriterProperties(writerId));
        return textWriter;
    }

    public TextProcessor getProcessor(String processId) {
        String processorClass = this.config.getProcessorClass(processId);
        if (StringUtil.isEmpty((String)processorClass)) {
            throw new TextRuntimeException(String.valueOf(processId) + " TextProcess is undefined!");
        }
        TextProcessor textProcessor = (TextProcessor)ClassUtil.newInstance((String)processorClass);
        if (textProcessor == null) {
            throw new TextRuntimeException("Fail to new instance for " + processorClass + " class");
        }
        textProcessor.init(this.config.getProcessorProperties(processId));
        return textProcessor;
    }

    public TextProcessor getProcessor(String processId, TextIO textIO) {
        String processorClass = this.config.getProcessorClass(processId);
        if (StringUtil.isEmpty((String)processorClass)) {
            throw new TextRuntimeException(String.valueOf(processId) + " TextProcess is undefined!");
        }
        TextProcessor textProcessor = (TextProcessor)ClassUtil.newInstance((String)processorClass, (Class[])new Class[]{textIO.getClass()}, (Object[])new TextIO[]{textIO});
        if (textProcessor == null) {
            throw new TextRuntimeException("Fail to new instance for " + processorClass + " class");
        }
        textProcessor.init(this.config.getProcessorProperties(processId));
        return textProcessor;
    }
}

