/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.util.Filter;
import com.tradevan.taurus.text.TextRuntimeException;

public class TextCondition
implements Filter {
    public static final String LOGIC_AND = "AND";
    public static final String LOGIC_OR = "OR";
    private String logic = "AND";
    private String startWith = null;
    private String endWith = null;
    private String equals = null;
    private String contains = null;

    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        return this.check(object.toString());
    }

    private boolean check(String line) {
        byte[] bits = new byte[]{1, 2, 4, 8};
        byte targetValue = 0;
        byte checkValue = 0;
        int index = 0;
        if (this.startWith != null) {
            targetValue = (byte)(targetValue + bits[index]);
            if (line.startsWith(this.startWith)) {
                checkValue = (byte)(checkValue + bits[index]);
            }
            ++index;
        }
        if (this.endWith != null) {
            targetValue = (byte)(targetValue + bits[index]);
            if (line.endsWith(this.endWith)) {
                checkValue = (byte)(checkValue + bits[index]);
            }
            ++index;
        }
        if (this.equals != null) {
            targetValue = (byte)(targetValue + bits[index]);
            if (line.equals(this.equals)) {
                checkValue = (byte)(checkValue + bits[index]);
            }
            ++index;
        }
        if (this.contains != null) {
            targetValue = (byte)(targetValue + bits[index]);
            if (line.indexOf(this.contains) > -1) {
                checkValue = (byte)(checkValue + bits[index]);
            }
            ++index;
        }
        if (LOGIC_AND.equals(this.logic)) {
            return checkValue == targetValue;
        }
        return checkValue != 0;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        if (LOGIC_AND.equalsIgnoreCase(logic)) {
            this.logic = LOGIC_AND;
        } else if (LOGIC_OR.equalsIgnoreCase(logic)) {
            this.logic = LOGIC_OR;
        } else {
            throw new TextRuntimeException("The logic parameter must be one of LOGIC_AND and LOGIC_OR.");
        }
    }

    public String getStartWith() {
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
    }

    public String getEndWith() {
        return this.endWith;
    }

    public void setEndWith(String endWith) {
        this.endWith = endWith;
    }

    public String getEquals() {
        return this.equals;
    }

    public void setEquals(String equals) {
        this.equals = equals;
    }

    public String getContains() {
        return this.contains;
    }

    public void setContains(String contains) {
        this.contains = contains;
    }
}

