/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.util.Filter;
import com.tradevan.commons.util.Processor;
import com.tradevan.commons.util.Transformer;
import com.tradevan.taurus.text.IOProcessor;
import java.util.ArrayList;
import java.util.List;

public class SequenceProcessor
extends IOProcessor {
    private List processorList = new ArrayList();

    public void addFilter(Filter filter) {
        super.addFilter(filter);
        this.processorList.add(filter);
    }

    public void addTransformer(Transformer transformer) {
        super.addTransformer(transformer);
        this.processorList.add(transformer);
    }

    public void addProcessor(Processor processor) {
        super.addProcessor(processor);
        this.processorList.add(processor);
    }

    public String process(String line) {
        if (!this.processorList.isEmpty()) {
            Object tmp = line;
            int i = 0;
            while (i < this.processorList.size()) {
                Object p = this.processorList.get(i);
                if (p instanceof Filter) {
                    if (!((Filter)p).accept(tmp)) {
                        return null;
                    }
                } else if (p instanceof Transformer) {
                    tmp = ((Transformer)p).transform(tmp);
                } else if (p instanceof Processor) {
                    ((Processor)p).execute(tmp);
                }
                ++i;
            }
            line = tmp != null ? tmp.toString() : null;
        }
        return line;
    }
}

