/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.util.Filter;
import com.tradevan.commons.util.Processor;
import com.tradevan.commons.util.Transformer;
import java.util.ArrayList;
import java.util.List;

public class IOProcessor {
    protected List filters = null;
    protected List transformers = null;
    protected List processors = null;

    public boolean accept(Object line) {
        if (this.filters == null || this.filters.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.filters.size()) {
            Filter filter = (Filter)this.filters.get(i);
            if (!filter.accept(line)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addFilter(Filter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList(2);
        }
        this.filters.add(filter);
    }

    public void addProcessor(Processor processor) {
        if (this.processors == null) {
            this.processors = new ArrayList(2);
        }
        this.processors.add(processor);
    }

    public void addTransformer(Transformer transformer) {
        if (this.transformers == null) {
            this.transformers = new ArrayList(2);
        }
        this.transformers.add(transformer);
    }

    public void execute(Object line) {
        if (this.processors == null || this.processors.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.processors.size()) {
            Processor processor = (Processor)this.processors.get(i);
            processor.execute(line);
            ++i;
        }
    }

    public List getFilters() {
        return this.filters;
    }

    public List getProcessors() {
        return this.processors;
    }

    public List getTransformers() {
        return this.transformers;
    }

    public Object process(Object obj) {
        if (this.accept(obj)) {
            this.execute(obj);
            return this.transform(obj);
        }
        return null;
    }

    public String processToLine(Object obj) {
        if ((obj = this.process(obj)) instanceof String) {
            return (String)obj;
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public Object transform(Object line) {
        if (this.transformers == null || this.transformers.isEmpty()) {
            return line;
        }
        Object tmp = line;
        int i = 0;
        while (i < this.transformers.size()) {
            Transformer transformer = (Transformer)this.transformers.get(i);
            tmp = transformer.transform(tmp);
            ++i;
        }
        if (tmp != null) {
            return tmp;
        }
        return "";
    }
}

