/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging.handler;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.LogFormat;
import com.tradevan.commons.logging.LogLevel;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.handler.Handler;
import com.tradevan.commons.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class FileRollingHandler
extends Handler {
    private static final String PATTERN = "pattern";
    private static final String FILENAME = "filename";
    private static final String ROLLING = "rolling";
    private static final String MAX_FILE_SIZE = "max-size";
    private static final String MAX_BACKUP_INDEX = "max-backup-index";
    private static final String TIME_FORMAT = "time-format";
    private PrintStream ps = null;
    private FileOutputStream fos = null;
    private boolean rolling = true;
    private long max_file_size = 0x200000L;
    private int max_backup_index = 5;
    private String filename;
    private LogFormat format = null;

    public void init(Properties prop) {
        try {
            String s;
            String pattern = prop.getProperty(PATTERN);
            String timeFormat = prop.getProperty(TIME_FORMAT);
            if (!StringUtil.isEmpty((String)pattern)) {
                this.format = new LogFormat(pattern, timeFormat);
            }
            this.rolling = !"false".equals(s = prop.getProperty(ROLLING));
            s = prop.getProperty(MAX_FILE_SIZE);
            if (s != null && !"".equals(s.trim())) {
                this.max_file_size = Integer.parseInt(s) * 1024;
            }
            if ((s = prop.getProperty(MAX_BACKUP_INDEX)) != null && !"".equals(s.trim())) {
                this.max_backup_index = Integer.parseInt(s);
            }
            this.filename = prop.getProperty(FILENAME);
            if (this.filename != null && !"".equals(this.filename.trim())) {
                File file = new File(this.filename);
                if (!file.getAbsoluteFile().getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                this.fos = new FileOutputStream(this.filename, true);
                this.ps = new PrintStream(this.fos);
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)("FileHandler initiation has error! " + e));
        }
    }

    public void write(LogLevel level, Object logObj, Throwable t) {
        if (this.ps != null) {
            if (logObj instanceof LogObject) {
                String msg;
                LogObject log = (LogObject)logObj;
                if (this.format != null) {
                    msg = this.format.format(level, log);
                } else {
                    Date d = new Date(log.getLogTime());
                    msg = d + " [" + level + "] " + log.getMessage();
                }
                this.out(msg, t);
            } else {
                String time = Calendar.getInstance().getTime().toString();
                String msg = time + " [" + level + "] " + logObj;
                this.out(msg, t);
            }
        }
    }

    private synchronized void out(String msg, Throwable t) {
        try {
            this.ps.println(msg);
            if (t != null) {
                t.printStackTrace(this.ps);
            }
            this.ps.flush();
            FileChannel fc = this.fos.getChannel();
            if (fc.size() >= this.max_file_size) {
                this.fos.close();
                this.ps.close();
                this.fos = this.shiftBackupFile() ? new FileOutputStream(this.filename) : new FileOutputStream(this.filename, true);
                this.ps = new PrintStream(this.fos);
            }
        }
        catch (Exception e) {
            System.err.println("FileHandler has error! " + e);
        }
    }

    private boolean shiftBackupFile() {
        int i = this.max_backup_index;
        boolean ok = false;
        do {
            File f = i == 0 ? new File(this.filename) : new File(this.filename + "." + i);
            File backFile = new File(this.filename + "." + (i + 1));
            System.out.println("f -> " + f.getName());
            System.out.println("backFile -> " + backFile.getName());
            if (!this.rolling || !f.exists()) continue;
            if (i == this.max_backup_index) {
                ok = f.delete();
                System.out.println("delete last:" + ok);
                continue;
            }
            ok = f.renameTo(backFile);
            System.out.println(f.getName() + " rename to " + backFile.getName() + ">>" + ok);
        } while (--i >= 0);
        return ok;
    }
}

