/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging.handler;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.LogFormat;
import com.tradevan.commons.logging.LogLevel;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.handler.FileHandler;
import com.tradevan.commons.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class DailyFileHandler
extends FileHandler {
    private PrintStream ps = null;
    private FileOutputStream fos = null;
    private boolean rolling = true;
    private long max_file_size = 0x200000L;
    private int max_backup_index = 5;
    private String filename;
    private LogFormat format = null;
    private String date_pattern;

    public void init(Properties prop) {
        try {
            String s;
            String pattern = prop.getProperty("pattern");
            String timeFormat = prop.getProperty("time-format");
            this.date_pattern = prop.getProperty("date-pattern");
            if (StringUtil.isEmpty((String)this.date_pattern)) {
                this.date_pattern = ".yyyy-MM-dd";
            }
            if (!StringUtil.isEmpty((String)pattern)) {
                this.format = new LogFormat(pattern, timeFormat);
            }
            this.rolling = !"false".equals(s = prop.getProperty("rolling"));
            s = prop.getProperty("max-size");
            if (s != null && !"".equals(s.trim())) {
                this.max_file_size = Integer.parseInt(s) * 1024;
            }
            if ((s = prop.getProperty("max-backup-index")) != null && !"".equals(s.trim())) {
                this.max_backup_index = Integer.parseInt(s);
            }
            this.filename = prop.getProperty("filename");
            if (this.filename != null && !"".equals(this.filename.trim())) {
                File file = new File(this.filename);
                if (!file.getAbsoluteFile().getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                this.fos = new FileOutputStream(this.filename, true);
                this.ps = new PrintStream(this.fos);
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)("FileHandler initiation has error! " + e));
        }
    }

    public void write(LogLevel level, Object logObj, Throwable t) {
        if (this.ps != null) {
            if (logObj instanceof LogObject) {
                String msg;
                LogObject log = (LogObject)logObj;
                if (this.format != null) {
                    msg = this.format.format(level, log);
                } else {
                    Date d = new Date(log.getLogTime());
                    msg = d + " [" + level + "] " + log.getMessage();
                }
                this.out(msg, t);
            } else {
                String time = Calendar.getInstance().getTime().toString();
                String msg = time + " [" + level + "] " + logObj;
                this.out(msg, t);
            }
        }
    }

    private synchronized void out(String msg, Throwable t) {
        try {
            File currentFile = new File(this.filename);
            Date lastModifiedDate = new Date(currentFile.lastModified());
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            if (lastModifiedDate.getTime() <= cal.getTimeInMillis()) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.date_pattern);
                File backupFile = this.getBackupFile(lastModifiedDate, sdf);
                this.fos.close();
                this.ps.close();
                this.fos = currentFile.renameTo(backupFile) ? new FileOutputStream(this.filename) : new FileOutputStream(this.filename, true);
                this.ps = new PrintStream(this.fos);
                this.keepMaxBackupFile(sdf);
            }
            this.ps.println(msg);
            if (t != null) {
                t.printStackTrace(this.ps);
            }
            this.ps.flush();
        }
        catch (Exception e) {
            System.err.println("FileHandler has error! " + e);
        }
    }

    private File getBackupFile(Date lastModifiedDate, SimpleDateFormat sdf) {
        File f = new File(this.filename + sdf.format(lastModifiedDate));
        if (f.exists()) {
            f.delete();
        }
        return f;
    }

    private void keepMaxBackupFile(SimpleDateFormat sdf) {
        File bak;
        Calendar cal = Calendar.getInstance();
        int i = 0;
        do {
            cal.set(6, cal.get(6) - 1);
            bak = new File(this.filename + sdf.format(cal.getTime()));
            ++i;
            if (!this.rolling) break;
            if (i <= this.max_backup_index || !bak.exists()) continue;
            bak.delete();
            break;
        } while (bak.exists());
    }
}

