/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging.handler;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.LogFormat;
import com.tradevan.commons.logging.LogLevel;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.handler.Handler;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class ConsoleHandler
extends Handler {
    private static final String PATTERN = "pattern";
    private static final String TIME_FORMAT = "time-format";
    private LogFormat format = null;

    public void init(Properties prop) {
        String pattern = prop.getProperty(PATTERN);
        String timeFormat = prop.getProperty(TIME_FORMAT);
        if (!StringUtil.isEmpty((String)pattern)) {
            this.format = new LogFormat(pattern, timeFormat);
        }
    }

    public void write(LogLevel level, Object logObj, Throwable t) {
        if (logObj instanceof LogObject) {
            String msg;
            LogObject log = (LogObject)logObj;
            if (this.format != null) {
                msg = this.format.format(level, log);
            } else {
                Date d = new Date(log.getLogTime());
                msg = d + " [" + level + "] " + log.getMessage();
            }
            System.out.println(msg);
        } else {
            String time = Calendar.getInstance().getTime().toString();
            String msg = time + " [" + level + "] " + logObj;
            System.out.println(msg);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }
}

