/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging.event;

import com.tradevan.commons.config.Config;
import com.tradevan.commons.config.ConfigFactory;
import com.tradevan.commons.logging.event.Event;
import com.tradevan.commons.logging.event.EventCode;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EventConfig {
    private static final String KEY_EVENT_ID = "Event/@id";
    private static final String KEY_EVENT_LEVEL = "Event[@id=''{0}'']/@level";
    private static final String KEY_EVENT_DESC = "Event[@id=''{0}'']/Description";
    private static final String KEY_EVENT_CODE = "Event[@id=''{0}'']/Code/@value";
    private static final String KEY_CODE_LEVEL = "Event[@id=''{0}'']/Code[@value=''{1}'']/@level";
    private static final String KEY_CODE_MSG = "Event[@id=''{0}'']/Code[@value=''{1}'']/Msg";
    private static final String KEY_CODE_INSTRUCTION = "Event[@id=''{0}'']/Code[@value=''{1}'']/Instruction";
    private Map events = new HashMap();
    private Map eventCodes = new HashMap();
    private Config config;

    public EventConfig(String event_conf) {
        this.init(event_conf);
    }

    private void init(String event_conf) {
        this.config = ConfigFactory.newConfig((String)event_conf, (boolean)false, (String)"UTF-8");
        if (this.config != null) {
            this.config.enableXpath(true);
            String[] eventId = this.config.getStringArray(KEY_EVENT_ID);
            for (int i = 0; i < eventId.length; ++i) {
                if (eventId[i] == null || "".equals(eventId[i])) continue;
                Event evt = new Event();
                evt.setId(eventId[i]);
                evt.setLevel(this.getString(KEY_EVENT_LEVEL, eventId[i]));
                evt.setDescription(this.getString(KEY_EVENT_DESC, eventId[i]));
                String[] code = this.getStringArray(KEY_EVENT_CODE, eventId[i]);
                for (int j = 0; j < code.length; ++j) {
                    if (code[j] == null || "".equals(code[j])) continue;
                    EventCode evtCode = new EventCode();
                    evtCode.setEvent(evt);
                    evtCode.setCode(code[j]);
                    String level = this.getCode(KEY_CODE_LEVEL, eventId[i], code[j]);
                    if (level == null || "".equals(level.trim())) {
                        level = evt.getLevel();
                    }
                    level = level != null && !"".equals(level.trim()) ? level : evt.getLevel();
                    evtCode.setLevel(level);
                    evtCode.setMessage(this.getCode(KEY_CODE_MSG, eventId[i], code[j]));
                    evtCode.setInstruction(this.getCode(KEY_CODE_INSTRUCTION, eventId[i], code[j]));
                    evt.addEventCode(evtCode);
                    this.eventCodes.put(evt.getId() + evtCode.getCode(), evtCode);
                }
                this.events.put(evt.getId(), evt);
            }
        }
    }

    public Collection getEvents() {
        return this.events.values();
    }

    public Event getEvent(String eventId) {
        return (Event)this.events.get(eventId);
    }

    public EventCode getEventCode(String event, String code) {
        return (EventCode)this.eventCodes.get(event + code);
    }

    private String getString(String key, String str) {
        Object[] s = new Object[]{str};
        return this.config.getString(MessageFormat.format(key, s));
    }

    private String[] getStringArray(String key, String str) {
        Object[] s = new Object[]{str};
        return this.config.getStringArray(MessageFormat.format(key, s));
    }

    private String getCode(String key, String event, String code) {
        return this.config.getString(MessageFormat.format(key, event, code));
    }
}

