/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import com.tradevan.commons.logging.LogFactory;
import com.tradevan.commons.logging.LogLevel;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.handler.Handler;
import com.tradevan.commons.util.CommonLogger;
import com.tradevan.commons.util.LogUtil;

public class Logger
extends CommonLogger {
    protected LogLevel logLevel;
    protected Handler[] handlers;
    protected LogFactory factory = null;

    protected Logger() {
        this.logLevel = LogLevel.OFF;
    }

    protected Logger(LogLevel logLevel) {
        this.setLevel(logLevel);
    }

    public void setLevel(LogLevel level) {
        this.logLevel = level == null ? LogLevel.OFF : level;
    }

    public LogLevel getLevel() {
        return this.logLevel;
    }

    public void setHandlers(Handler[] handlers) {
        this.handlers = handlers;
    }

    public Handler[] getHandlers() {
        return this.handlers;
    }

    public void log(LogLevel level, Object logObj) {
        try {
            if (this.handlers != null) {
                if (!(logObj instanceof LogObject)) {
                    logObj = logObj != null ? this.factory.newLogObject(logObj.toString()) : this.factory.newLogObject(null);
                }
                for (int i = 0; i < this.handlers.length; ++i) {
                    if (this.handlers[i] == null) continue;
                    this.handlers[i].write(level, logObj, null);
                }
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)e, (Throwable)e);
        }
    }

    public void log(LogLevel level, Object logObj, Throwable t) {
        try {
            if (this.handlers != null) {
                if (!(logObj instanceof LogObject)) {
                    logObj = logObj != null ? this.factory.newLogObject(logObj.toString()) : this.factory.newLogObject(null);
                }
                for (int i = 0; i < this.handlers.length; ++i) {
                    if (this.handlers[i] == null) continue;
                    this.handlers[i].write(level, logObj, t);
                }
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error((Object)e, (Throwable)e);
        }
    }

    public void fatal(Object logObj) {
        if (this.logLevel.intValue() >= 1) {
            this.log(LogLevel.FATAL, logObj);
        }
    }

    public void fatal(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 1) {
            this.log(LogLevel.FATAL, logObj, t);
        }
    }

    public void error(Object logObj) {
        if (this.logLevel.intValue() >= 2) {
            this.log(LogLevel.ERROR, logObj);
        }
    }

    public void error(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 2) {
            this.log(LogLevel.ERROR, logObj, t);
        }
    }

    public void warn(Object logObj) {
        if (this.logLevel.intValue() >= 3) {
            this.log(LogLevel.WARN, logObj);
        }
    }

    public void warn(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 3) {
            this.log(LogLevel.WARN, logObj, t);
        }
    }

    public void info(Object logObj) {
        if (this.logLevel.intValue() >= 4) {
            this.log(LogLevel.INFO, logObj);
        }
    }

    public void info(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 4) {
            this.log(LogLevel.INFO, logObj, t);
        }
    }

    public void debug(Object logObj) {
        if (this.logLevel.intValue() >= 5) {
            this.log(LogLevel.DEBUG, logObj);
        }
    }

    public void debug(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 5) {
            this.log(LogLevel.DEBUG, logObj, t);
        }
    }

    public void trace(Object logObj) {
        if (this.logLevel.intValue() >= 6) {
            this.log(LogLevel.TRACE, logObj);
        }
    }

    public void trace(Object logObj, Throwable t) {
        if (this.logLevel.intValue() >= 6) {
            this.log(LogLevel.TRACE, logObj, t);
        }
    }

    protected void setLogFactory(LogFactory factory) {
        this.factory = factory;
    }
}

