/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.event.Event;
import com.tradevan.commons.logging.event.EventCode;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public class LogObject
implements Serializable {
    private static final long serialVersionUID = 1744738799042335136L;
    private long logTime;
    private String programName;
    private String objectName;
    private String systemName;
    private String execCommand;
    private String message;
    private Event event;
    private EventCode eventCode;
    private String instruction;
    private String IP;
    private String hostname;
    private String OSCode;
    private String DBCode;
    private Object extraArguments = null;

    protected LogObject(int logTime, String msg) {
        this.logTime = logTime;
        this.message = msg;
    }

    protected LogObject(String msg) {
        this.logTime = System.currentTimeMillis();
        this.message = msg;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setExecCommand(String execCommand) {
        this.execCommand = execCommand;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setEventCode(EventCode eventCode) {
        this.eventCode = eventCode;
    }

    public void setLogTime(long logTime) {
        this.logTime = logTime;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setDBCode(String DBCode) {
        this.DBCode = DBCode;
    }

    public void setOSCode(String OSCode) {
        this.OSCode = OSCode;
    }

    public void setIP(String IP) {
        this.IP = IP;
    }

    public String getProgramName() {
        return this.programName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getExecCommand() {
        return this.execCommand;
    }

    public String getMessage() {
        return this.message;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public EventCode getEventCode() {
        return this.eventCode;
    }

    public long getLogTime() {
        return this.logTime;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getDBCode() {
        return this.DBCode;
    }

    public String getOSCode() {
        return this.OSCode;
    }

    public String getIP() {
        return this.IP;
    }

    public void setArguments(Object arguments) {
        this.extraArguments = arguments;
    }

    public Object getArguments() {
        return this.extraArguments;
    }

    public String toString() {
        Date date = new Date(this.logTime);
        if (this.eventCode != null) {
            return date + " {" + this.eventCode + "} " + this.getFormattedMessage();
        }
        return date + this.getFormattedMessage();
    }

    private String getFormattedMessage() {
        if (this.extraArguments != null) {
            if (this.extraArguments instanceof Map) {
                return StringUtil.replaceVariable((String)this.message, (Map)((Map)this.extraArguments));
            }
            if (this.extraArguments instanceof Object[]) {
                return MessageFormat.format(this.message, (Object[])this.extraArguments);
            }
        }
        return this.message;
    }
}

