/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LogLevel
implements Serializable {
    private static final long serialVersionUID = 6335133650661042133L;
    public static final int VALUE_OFF = 0;
    public static final int VALUE_FATAL = 1;
    public static final int VALUE_ERROR = 2;
    public static final int VALUE_WARN = 3;
    public static final int VALUE_INFO = 4;
    public static final int VALUE_DEBUG = 5;
    public static final int VALUE_TRACE = 6;
    public static final LogLevel OFF = new LogLevel("OFF", 0);
    public static final LogLevel FATAL = new LogLevel("FATAL", 1);
    public static final LogLevel ERROR = new LogLevel("ERROR", 2);
    public static final LogLevel WARN = new LogLevel("WARN", 3);
    public static final LogLevel INFO = new LogLevel("INFO", 4);
    public static final LogLevel DEBUG = new LogLevel("DEBUG", 5);
    public static final LogLevel TRACE = new LogLevel("TRACE", 6);
    private static Map levelMap = new HashMap();
    private int level_value;
    private String level_label;

    protected LogLevel(String label, int value) {
        this.level_value = value;
        this.level_label = label;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() != obj.getClass()) {
            return false;
        }
        return this.level_value == ((LogLevel)obj).level_value;
    }

    public boolean isEnabled(LogLevel level) {
        return this.level_value <= level.intValue();
    }

    public int intValue() {
        return this.level_value;
    }

    public static LogLevel parse(String level) {
        if (level != null) {
            return (LogLevel)levelMap.get(level.toUpperCase());
        }
        return null;
    }

    public String toString() {
        return this.level_label;
    }

    static {
        levelMap.put("OFF", OFF);
        levelMap.put("FATAL", FATAL);
        levelMap.put("ERROR", ERROR);
        levelMap.put("WARN", WARN);
        levelMap.put("INFO", INFO);
        levelMap.put("DEBUG", DEBUG);
        levelMap.put("TRACE", TRACE);
    }
}

