/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.LogLevel;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.event.Event;
import com.tradevan.commons.logging.event.EventCode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LogFormat {
    private SimpleDateFormat sdf = null;
    private String pattern = null;

    public LogFormat() {
    }

    public LogFormat(String pattern, String dateFormat) {
        this.pattern = pattern;
        if (!StringUtil.isEmpty((String)dateFormat)) {
            this.sdf = new SimpleDateFormat(dateFormat);
        }
    }

    public static String format(String pattern, LogLevel level, LogObject logObj) {
        LogFormat format = new LogFormat(pattern, null);
        return format.format(level, logObj);
    }

    public String format(LogLevel level, LogObject logObj) {
        EventCode eventCode;
        Event event;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object arguments = logObj.getArguments();
        if (arguments != null && arguments instanceof Map) {
            map.putAll((Map)arguments);
        }
        if ((event = logObj.getEvent()) != null) {
            map.put("event.id", event.getId());
            map.put("event.description", LogFormat.formatMessage(event.getDescription(), arguments));
            map.put("event.level", event.getLevel());
        }
        if ((eventCode = logObj.getEventCode()) != null) {
            map.put("code", eventCode.getCode());
            map.put("code.instruction", LogFormat.formatMessage(eventCode.getInstruction(), arguments));
            map.put("code.level", eventCode.getLevel());
            map.put("code.msg", LogFormat.formatMessage(eventCode.getMessage(), arguments));
        }
        map.put("level", level);
        map.put("cmd", logObj.getExecCommand());
        map.put("host", logObj.getHostname());
        map.put("instruction", logObj.getInstruction());
        map.put("ip", logObj.getIP());
        if (this.sdf == null) {
            map.put("time", new Date(logObj.getLogTime()));
        } else {
            map.put("time", this.sdf.format(new Date(logObj.getLogTime())));
        }
        map.put("msg", LogFormat.formatMessage(logObj.getMessage(), arguments));
        map.put("object", logObj.getObjectName());
        map.put("program", logObj.getProgramName());
        map.put("system", logObj.getSystemName());
        map.put("db.code", logObj.getDBCode());
        map.put("os.code", logObj.getOSCode());
        return StringUtil.replaceVariable((String)this.pattern, map);
    }

    private static String formatMessage(String msg, Object arguments) {
        if (arguments != null) {
            if (arguments instanceof Map) {
                return StringUtil.replaceVariable((String)msg, (Map)((Map)arguments));
            }
            if (arguments instanceof Object[]) {
                return MessageFormat.format(msg, (Object[])arguments);
            }
        }
        return msg;
    }
}

