/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.lang.ClassUtil;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.logging.LogConfig;
import com.tradevan.commons.logging.LogObject;
import com.tradevan.commons.logging.Logger;
import com.tradevan.commons.logging.event.Event;
import com.tradevan.commons.logging.event.EventCode;
import com.tradevan.commons.logging.event.EventConfig;
import com.tradevan.commons.logging.handler.Handler;
import com.tradevan.commons.util.LogUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LogFactory {
    private static String COMMON_LOGGER = "CommonLogger";
    private static Logger LOGGER = new Logger();
    private static LogFactory me = null;
    private static Map factoryMap = new HashMap();
    private LogConfig config;
    private EventConfig eventConfig;
    private Map logger;
    private Map handlerMap = new HashMap();
    private String system_name;
    private String ip;
    private String hostname;

    public LogFactory(LogConfig config) {
        this.config = config;
        String event_config = config.getEventConfigFile();
        if (event_config != null && event_config.trim().length() > 0) {
            this.eventConfig = new EventConfig(event_config);
        }
        this.logger = new HashMap();
        this.system_name = config.getSystemName();
        this.ip = config.getIP();
        this.hostname = config.getHostname();
        if (ArrayUtil.isEmpty((Object)LOGGER.getHandlers())) {
            LOGGER = this.getLogger(COMMON_LOGGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory getInstance() {
        if (me == null) {
            Class clazz = LogFactory.class;
            synchronized (clazz) {
                if (me == null) {
                    me = new LogFactory(LogConfig.getInstance());
                    if (ArrayUtil.isEmpty((Object)LOGGER.getHandlers())) {
                        LOGGER = me.getLogger(COMMON_LOGGER);
                    }
                }
            }
        }
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(LogConfig logConfig) {
        if (logConfig == null) {
            throw new IllegalArgumentException("LogConfig is null!");
        }
        String system_name = logConfig.getSystemName();
        if (system_name != null && system_name.trim().length() > 0) {
            LogFactory factory = new LogFactory(logConfig);
            Map map = factoryMap;
            synchronized (map) {
                factoryMap.put(system_name, factory);
            }
        }
    }

    public static LogFactory getInstance(String system_name) {
        return (LogFactory)factoryMap.get(system_name);
    }

    private Logger createLogger(String log_name) {
        Logger logger;
        String logClass = this.config.getLogClass(log_name);
        if (StringUtil.isEmpty((String)logClass)) {
            logger = new Logger(this.config.getLogLevel(log_name));
        } else {
            logger = (Logger)((Object)ClassUtil.newInstance((String)logClass));
            if (logger == null) {
                LogUtil.LOGGER.error((Object)("Fail to instant logger class: " + logClass));
                logger = new Logger(this.config.getLogLevel(log_name));
            } else {
                logger.setLevel(this.config.getLogLevel(log_name));
            }
        }
        try {
            String[] handler = this.config.getLogHandler(log_name);
            if (handler != null) {
                Handler[] handlers = new Handler[handler.length];
                for (int i = 0; i < handler.length; ++i) {
                    handlers[i] = this.getHandler(handler[i]);
                }
                logger.setHandlers(handlers);
                logger.setLogFactory(this);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Fail to initiate logger '" + log_name + "' :" + t.getMessage(), t);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler(String name) {
        Handler handler = (Handler)this.handlerMap.get(name);
        if (handler == null) {
            Map map = this.handlerMap;
            synchronized (map) {
                if (this.handlerMap.get(name) == null) {
                    try {
                        handler = this.newHandler(name);
                        if (handler != null) {
                            this.handlerMap.put(name, handler);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Fail to instant " + name + " handler! " + e.getMessage());
                    }
                } else {
                    handler = (Handler)this.handlerMap.get(name);
                }
            }
        }
        return handler;
    }

    private Handler newHandler(String name) {
        Handler handler = (Handler)ClassUtil.newInstance((String)this.config.getHandlerClass(name));
        if (handler != null) {
            handler.setName(name);
            Properties handlerProp = new Properties();
            String[] prop = this.config.getHandlerProperties(name);
            if (prop.length > 0) {
                for (int i = 0; i < prop.length; ++i) {
                    handlerProp.setProperty(prop[i], this.config.getHandlerProperty(name, prop[i]));
                }
            }
            handler.init(handlerProp);
        } else {
            LOGGER.error("Fail to instant " + name + " handler!");
        }
        return handler;
    }

    public LogObject newLogObject(String msg) {
        LogObject logObj = new LogObject(msg);
        logObj.setSystemName(this.system_name);
        logObj.setIP(this.ip);
        logObj.setHostname(this.hostname);
        return logObj;
    }

    public LogObject newLogObject(String eventId, String code) {
        Event event;
        LogObject logObj = null;
        if (this.eventConfig != null && (event = this.eventConfig.getEvent(eventId)) != null) {
            EventCode eventCode = event.getEventCode(code);
            if (eventCode != null) {
                logObj = this.newLogObject(eventCode.getMessage());
                logObj.setEventCode(eventCode);
                logObj.setInstruction(eventCode.getInstruction());
                logObj.setMessage(eventCode.getMessage());
            } else {
                logObj = this.newLogObject(event.getDescription());
            }
            logObj.setEvent(event);
        }
        return logObj;
    }

    public LogObject newLogObject(String eventId, String code, String msg) {
        LogObject logObj = this.newLogObject(eventId, code);
        if (logObj != null) {
            logObj.setMessage(msg);
        } else {
            logObj = this.newLogObject(msg);
        }
        return logObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        Logger l = (Logger)((Object)this.logger.get(name));
        if (l == null) {
            Map map = this.logger;
            synchronized (map) {
                if (this.logger.get(name) == null) {
                    l = this.createLogger(name);
                    if (l != null) {
                        this.logger.put(name, l);
                    }
                } else {
                    l = (Logger)((Object)this.logger.get(name));
                }
            }
        }
        return l;
    }

    public EventConfig getEventConfig() {
        return this.eventConfig;
    }

    public LogConfig getLogConfig() {
        return this.config;
    }
}

