/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.logging;

import com.tradevan.commons.config.Config;
import com.tradevan.commons.config.ConfigFactory;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.lang.SystemUtil;
import com.tradevan.commons.logging.LogLevel;
import java.text.MessageFormat;

public class LogConfig {
    private static final String CONFIG_FILE = "/conf/logging.xml";
    private static final String KEY_EVENT_CONFIG_FILE = "event-config/@file";
    private static final String KEY_SYSTEM_NAME = "system/name";
    private static final String KEY_IP = "system/ip";
    private static final String KEY_HOSTNAME = "system/hostname";
    private static final String KEY_LOGGERS = "logger/@name";
    private static final String KEY_HANDLERS = "handler/@name";
    private static final String KEY_LOG_HANDLER = "logger[@name=''{0}'']/handler/@name";
    private static final String KEY_HANDLER_CLASS = "handler[@name=''{0}'']/@class";
    private static final String KEY_HANDLER_PROPERTY = "handler[@name=''{0}'']/property[@name=''{1}'']/@value";
    private static final String KEY_HANDLER_PROPERTIES = "handler[@name=''{0}'']/property/@name";
    private static final String KEY_LOG_LEVEL = "logger[@name=''{0}'']/@level";
    private static final String KEY_LOG_CLASS = "logger[@name=''{0}'']/@class";
    private static LogConfig me = null;
    private Config config = null;

    public LogConfig(String conf) {
        this.config = ConfigFactory.newConfig((String)conf, null);
        if (this.config != null) {
            this.config.enableXpath(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogConfig getInstance() {
        if (me == null) {
            Class clazz = LogConfig.class;
            synchronized (clazz) {
                if (me == null) {
                    String file = SystemUtil.getSystemProperty((String)"LogConfig");
                    if (StringUtil.isEmpty((String)file)) {
                        file = CONFIG_FILE;
                    }
                    me = new LogConfig(file);
                }
            }
        }
        return me;
    }

    public String getEventConfigFile() {
        if (this.config == null) {
            return null;
        }
        return this.getString(KEY_EVENT_CONFIG_FILE);
    }

    public String getSystemName() {
        return this.getString(KEY_SYSTEM_NAME);
    }

    public String getIP() {
        return this.getString(KEY_IP);
    }

    public String getHostname() {
        return this.getString(KEY_HOSTNAME);
    }

    public String[] getLoggers() {
        return this.getStringArray(KEY_LOGGERS);
    }

    public String[] getHandlers() {
        return this.getStringArray(KEY_HANDLERS);
    }

    public String[] getLogHandler(String name) {
        return this.getStringArray(KEY_LOG_HANDLER, name);
    }

    public String getHandlerClass(String handler_name) {
        return this.getString(KEY_HANDLER_CLASS, handler_name);
    }

    public String getHandlerProperty(String handler_name, String prop_name) {
        Object[] s = new String[]{handler_name, prop_name};
        String key = MessageFormat.format(KEY_HANDLER_PROPERTY, s);
        return this.getString(key);
    }

    public String[] getHandlerProperties(String handler_name) {
        return this.getStringArray(KEY_HANDLER_PROPERTIES, handler_name);
    }

    public LogLevel getLogLevel(String log_name) {
        String level = this.getString(KEY_LOG_LEVEL, log_name);
        return LogLevel.parse(level);
    }

    public String getLogClass(String log_name) {
        return this.getString(KEY_LOG_CLASS, log_name);
    }

    private String getString(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getString(key);
    }

    private String getString(String key, String str) {
        if (this.config == null) {
            return null;
        }
        Object[] s = new Object[]{str};
        return this.config.getString(MessageFormat.format(key, s));
    }

    private String[] getStringArray(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getStringArray(key);
    }

    private String[] getStringArray(String key, String str) {
        if (this.config == null) {
            return null;
        }
        Object[] s = new Object[]{str};
        return this.config.getStringArray(MessageFormat.format(key, s));
    }
}

