/*
 * Decompiled with CFR 0.152.
 */
package com.formosoft.crypto;

import com.formosoft.crypto.FSP11Crypt;

public class P11Reference {
    private FSP11Crypt p11crypt;
    private int iSession;
    private int iSessionCount;

    public P11Reference(FSP11Crypt fSP11Crypt) {
        this.p11crypt = fSP11Crypt;
        this.iSession = 0;
        this.iSessionCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openSession() {
        int n = 0;
        P11Reference p11Reference = this;
        synchronized (p11Reference) {
            if (this.iSession == 0) {
                this.iSession = this.p11crypt.P11OpenSession();
                n = this.p11crypt.GetErrorCode();
            }
            ++this.iSessionCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        P11Reference p11Reference = this;
        synchronized (p11Reference) {
            --this.iSessionCount;
            if (this.iSessionCount == 0) {
                this.p11crypt.P11CloseSession(this.iSession);
                this.iSession = 0;
            }
        }
    }

    public int login(String string) {
        this.p11crypt.XP11Login(this.iSession, string);
        return this.p11crypt.GetErrorCode();
    }

    public int getPrivateKey(String string) {
        return this.p11crypt.XP11CryptGetPrivateKey(this.iSession, string, 0);
    }

    public int getPublicKey(String string) {
        return this.p11crypt.XP11CryptGetPublicKey(this.iSession, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCert(String string) {
        int n = 0;
        try {
            byte[] byArray;
            n = this.p11crypt.XP11CryptGetCertificate(this.iSession, string, 0);
            byte[] byArray2 = byArray = this.p11crypt.XEncodeObject(n, 1, 0);
            return byArray2;
        }
        finally {
            this.p11crypt.XFreeHandle(n);
        }
    }

    public int getErrorCode() {
        return this.p11crypt.GetErrorCode();
    }

    public int getSessionCount() {
        return this.iSessionCount;
    }
}

