/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.util;

import java.io.Serializable;

public class ThrowTracer
implements Serializable {
    private static final long serialVersionUID = 6849122180269829093L;
    private String packageName;
    private String className;
    private int lineNumber;
    private String methodName;
    private String fileName;
    private String message;

    public ThrowTracer() {
        Exception exception = new Exception();
        this.setThrowable(exception, null);
    }

    public ThrowTracer(Throwable throwable) {
        this.setThrowable(throwable, null);
    }

    public ThrowTracer(Throwable throwable, Class clazz) {
        this.setThrowable(throwable, clazz);
    }

    public void setThrowable(Throwable throwable, Class clazz) {
        if (throwable != null) {
            int i;
            this.message = throwable.getMessage();
            StackTraceElement[] st = throwable.getStackTrace();
            int index = 0;
            if (clazz != null) {
                this.className = clazz.getName();
                i = 0;
                while (i < st.length) {
                    if (this.className.equals(st[i].getClassName())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            if (st.length > 0) {
                this.className = st[index].getClassName();
                i = this.className.lastIndexOf(".");
                if (i > -1) {
                    this.packageName = this.className.substring(0, i);
                }
                this.lineNumber = st[index].getLineNumber();
                this.methodName = st[index].getMethodName();
                this.fileName = st[index].getFileName();
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.valueOf(this.className) + "." + this.methodName + "() at " + this.lineNumber + " in " + this.fileName + " throws message: " + this.message;
    }
}

