/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.util;

import com.tradevan.commons.CommonRuntimeException;
import com.tradevan.commons.lang.ClassUtil;
import com.tradevan.commons.lang.StringUtil;

public class BeanUtil {
    public static void setAttribute(Object beanObject, String attribute, Object value) {
        Object[] values = new Object[]{value};
        BeanUtil.setAttribute(beanObject, attribute, values);
    }

    public static void setAttribute(Object beanObject, String attribute, Object[] values) {
        if (beanObject == null || StringUtil.isEmpty(attribute)) {
            throw new CommonRuntimeException("bean object or attribute name must not be null or empty");
        }
        String methodName = "set" + BeanUtil.getMethodName(attribute);
        try {
            ClassUtil.invoke(beanObject, methodName, values);
        }
        catch (Exception e) {
            throw new CommonRuntimeException("Fail to set attribute " + attribute);
        }
    }

    public static Object getAttribute(Object beanObject, String attribute) {
        return BeanUtil.getAttribute(beanObject, attribute, null);
    }

    public static Object getAttribute(Object beanObject, String attribute, Object value) {
        Object[] values = new Object[]{value};
        return BeanUtil.getAttribute(beanObject, attribute, values);
    }

    public static Object getAttribute(Object beanObject, String attribute, Object[] values) {
        if (beanObject == null || StringUtil.isEmpty(attribute)) {
            throw new CommonRuntimeException("bean object or attribute name must not be null or empty");
        }
        String methodName = "get" + BeanUtil.getMethodName(attribute);
        try {
            return ClassUtil.invoke(beanObject, methodName, values);
        }
        catch (Exception e) {
            throw new CommonRuntimeException("Fail to get attribute" + attribute);
        }
    }

    public String getString(Object beanObject, String attribute) {
        Object value = BeanUtil.getAttribute(beanObject, attribute, null);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getString(Object beanObject, String attribute, Object value) {
        Object[] values = new Object[]{value};
        Object result = BeanUtil.getAttribute(beanObject, attribute, values);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getString(Object beanObject, String attribute, Object[] values) {
        Object value = BeanUtil.getAttribute(beanObject, attribute, values);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static String getMethodName(String attribute) {
        if (StringUtil.isEmpty(attribute)) {
            return attribute;
        }
        String name = "";
        String[] s = attribute.toLowerCase().split("[_-]");
        int i = 0;
        while (i < s.length) {
            name = s[i].length() > 1 ? String.valueOf(name) + Character.toUpperCase(s[i].charAt(0)) + s[i].substring(1) : String.valueOf(name) + Character.toUpperCase(s[i].charAt(0));
            ++i;
        }
        return name;
    }
}

