/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.lang.CharUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtil {
    public static final String EMPTY = "";
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";

    public static String abbreviate(String str, int maxLen) {
        return StringUtil.abbreviate(str, 0, maxLen);
    }

    public static String abbreviate(String str, int offset, int maxLen) {
        if (str == null) {
            return null;
        }
        if (maxLen < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        int strLength = str.length();
        if (strLength <= maxLen) {
            return str;
        }
        if (offset > strLength) {
            offset = strLength;
        }
        if (strLength - offset < maxLen - 3) {
            offset = strLength - (maxLen - 3);
        }
        if (offset <= 4) {
            return String.valueOf(str.substring(0, maxLen - 3)) + "...";
        }
        if (maxLen < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxLen - 3) < str.length()) {
            return "..." + StringUtil.abbreviate(str.substring(offset), maxLen - 3);
        }
        return "..." + str.substring(strLength - (maxLen - 3));
    }

    public static String alignStr(String str, int length, String align, String padding) {
        if (str != null && length > 0) {
            byte[] strbyte = str.getBytes();
            int strlen = 0;
            if (strbyte != null) {
                strlen = strbyte.length;
            }
            StringBuffer sb = null;
            if (length > strlen) {
                sb = new StringBuffer(str);
                if (padding == null || padding.length() == 0) {
                    padding = " ";
                }
                if (ALIGN_LEFT.equals(align)) {
                    sb.append(StringUtil.repeatStr(padding, length - strlen));
                } else if (ALIGN_RIGHT.equals(align)) {
                    sb.insert(0, StringUtil.repeatStr(padding, length - strlen));
                }
                return sb.toString();
            }
            return new String(ArrayUtil.subarray(strbyte, 0, length));
        }
        return str;
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static boolean containsAll(String str, String[] searchStr, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return false;
        }
        boolean contain = true;
        String tmpStr = null;
        if (ignoreCase) {
            str = str.toUpperCase();
        }
        int i = 0;
        while (i < searchStr.length) {
            tmpStr = ignoreCase ? searchStr[i].toUpperCase() : searchStr[i];
            if (str.indexOf(tmpStr) == -1) {
                contain = false;
                break;
            }
            ++i;
        }
        return contain;
    }

    public static boolean containsAny(String str, String[] searchStr, boolean ignoreCase) {
        if (str == null || searchStr == null) {
            return false;
        }
        boolean contain = false;
        String tmpStr = null;
        if (ignoreCase) {
            str = str.toUpperCase();
        }
        int i = 0;
        while (i < searchStr.length) {
            tmpStr = ignoreCase ? searchStr[i].toUpperCase() : searchStr[i];
            if (str.indexOf(tmpStr) > -1) {
                contain = true;
                break;
            }
            ++i;
        }
        return contain;
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.toUpperCase().indexOf(searchStr.toUpperCase()) >= 0;
    }

    public static String fillStr(String str, int length) {
        if (str == null) {
            return null;
        }
        if (length <= 0) {
            return EMPTY;
        }
        int strLength = str.length();
        if (strLength == 1) {
            return StringUtil.repeatStr(str, length);
        }
        char[] ch = str.toCharArray();
        char[] output2 = new char[length];
        int chLen = ch.length;
        int i = 0;
        while (i < length) {
            output2[i] = ch[i % chLen];
            ++i;
        }
        return new String(output2);
    }

    public static int indexOfAny(String str, String[] searchStr) {
        return StringUtil.indexOfAny(str, searchStr, 0);
    }

    public static int indexOfAny(String str, String[] searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        int sz = searchStr.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        int i = 0;
        while (i < sz) {
            String search = searchStr[i];
            if (search != null && (tmp = str.indexOf(search, startPos)) != -1 && tmp < ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int indexOfDifference(String str1, String str2) {
        if (str1 == str2) {
            return -1;
        }
        if (str1 == null || str2 == null) {
            return 0;
        }
        int str1Len = str1.length();
        int str2Len = str2.length();
        int i = 0;
        while (i < str1Len && i < str2Len) {
            if (str1.charAt(i) != str2.charAt(i)) break;
            ++i;
        }
        if (i < str1Len || i < str2Len) {
            return i;
        }
        return -1;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetter(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!CharUtil.isAsciiPrintable(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasEmpty(String[] str) {
        if (str == null || str.length == 0) {
            return true;
        }
        int i = 0;
        while (i < str.length) {
            if (str[i] == null || str[i].length() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String join(Collection collection) {
        if (collection == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer(collection.size() * 16);
        Iterator it = collection.iterator();
        Object obj = null;
        if (it.hasNext() && (obj = it.next()) != null) {
            sb.append((Object)obj);
        }
        while (it.hasNext()) {
            sb.append(separator);
            obj = it.next();
            if (obj == null) continue;
            sb.append((Object)obj);
        }
        return sb.toString();
    }

    public static String join(Object[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(array.length * 16);
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                sb.append(array[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtil.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return EMPTY;
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        while (array[startIndex] == null) {
            ++startIndex;
        }
        buf.append(array[startIndex]);
        int i = startIndex + 1;
        while (i < endIndex) {
            buf.append(separator);
            if (array[i] != null) {
                buf.append(array[i]);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String removeChar(String str, String searchChar) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(searchChar)) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        int i = 0;
        while (i < chars.length) {
            if (searchChar.indexOf(chars[i]) == -1) {
                chars[pos++] = chars[i];
            }
            ++i;
        }
        return new String(chars, 0, pos);
    }

    public static String removeStr(String str, String searchStr) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(searchStr)) {
            return str;
        }
        int start = 0;
        int end = str.indexOf(searchStr, start);
        if (end == -1) {
            return str;
        }
        int oldStrLen = searchStr.length();
        StringBuffer buf = new StringBuffer(str.length());
        while (end != -1) {
            buf.append(str.substring(start, end));
            start = end + oldStrLen;
            end = str.indexOf(searchStr, start);
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static String removeStr(String str, String[] searchStr) {
        if (StringUtil.isEmpty(str) || searchStr == null || searchStr.length == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        String strTmp = null;
        int i = 0;
        while (i < searchStr.length) {
            strTmp = searchStr[i];
            if (!StringUtil.isEmpty(strTmp)) {
                int start = 0;
                int len = strTmp.length();
                while ((start = sb.indexOf(strTmp, start)) > -1) {
                    sb.delete(start, start + len);
                }
                if (sb.length() == 0) break;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String repeatStr(String str, int times) {
        return StringUtil.repeat(str, times);
    }

    public static String repeat(char ch, int length) {
        char[] output1 = new char[length];
        int i = length - 1;
        while (i >= 0) {
            output1[i] = ch;
            --i;
        }
        return new String(output1);
    }

    public static String repeat(String str, int times) {
        if (str == null) {
            return null;
        }
        if (times <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (times == 1 || inputLength == 0) {
            return str;
        }
        int outputLength = inputLength * times;
        switch (inputLength) {
            case 1: {
                return StringUtil.repeat(str.charAt(0), outputLength);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                int i = times * 2 - 2;
                while (i >= 0) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuffer buf = new StringBuffer(outputLength);
        int i = 0;
        while (i < times) {
            buf.append(str);
            ++i;
        }
        return buf.toString();
    }

    public static String replace(String str, Map strMap) {
        if (StringUtil.isEmpty(str) || strMap == null || strMap.isEmpty()) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        Iterator it = strMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String newStr = strMap.get(key).toString();
            int start = 0;
            int end = sb.indexOf(key);
            int len = key.length();
            while (end > -1) {
                start = end;
                sb.replace(start, end += len, newStr);
                end = sb.indexOf(key, end);
            }
        }
        return sb.toString();
    }

    public static String replace(String str, String oldStr, String newStr) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(oldStr) || newStr == null) {
            return str;
        }
        int start = 0;
        int end = str.indexOf(oldStr, start);
        if (end == -1) {
            return str;
        }
        int oldStrLen = oldStr.length();
        StringBuffer buf = new StringBuffer(str.length());
        while (end != -1) {
            buf.append(str.substring(start, end)).append(newStr);
            start = end + oldStrLen;
            end = str.indexOf(oldStr, start);
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static String replaceFirst(String str, String oldStr, String newStr) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(oldStr) || newStr == null) {
            return str;
        }
        int end = str.indexOf(oldStr);
        if (end == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        buf.append(str.substring(0, end)).append(newStr).append(str.substring(end + oldStr.length()));
        return buf.toString();
    }

    public static String replaceLast(String str, String oldStr, String newStr) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(oldStr) || newStr == null) {
            return str;
        }
        int end = str.lastIndexOf(oldStr);
        if (end == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        buf.append(str.substring(0, end)).append(newStr).append(str.substring(end + oldStr.length()));
        return buf.toString();
    }

    public static String replaceVariable(String str, Map variables) {
        int i;
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        int start = 0;
        while ((i = str.indexOf("${", start)) != -1) {
            sb.append(str.substring(start, i));
            int j = str.indexOf("}", i);
            if (j != -1 && i + 2 < j) {
                Object value;
                String var = str.substring(i + 2, j);
                if (variables != null && (value = variables.get(var)) != null) {
                    sb.append(value);
                }
                start = j + 1;
                continue;
            }
            start = i;
            break;
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String[] splitByPattern(String str, String pattern) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(pattern)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] chArray = str.toCharArray();
        int start = 0;
        int length = chArray.length;
        int i = 0;
        while (i < length) {
            char ch = chArray[i];
            if (pattern.indexOf(ch) > -1) {
                start = i;
                int end = i + 1;
                while (end < length && ch == chArray[end]) {
                    ++end;
                }
                list.add(new String(chArray, start, end - start));
                i = end - 1;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] splitByStr(String str, String separator) {
        block3: {
            if (StringUtil.isEmpty(str) || StringUtil.isEmpty(separator)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            list = new ArrayList<String>();
            start = 0;
            i = str.indexOf(separator, start);
            if (i != -1) ** GOTO lbl14
            list.add(str);
            break block3;
lbl-1000:
            // 1 sources

            {
                list.add(str.substring(start, i));
                start = i + separator.length();
                i = str.indexOf(separator, start);
lbl14:
                // 2 sources

                ** while (i != -1)
            }
lbl15:
            // 1 sources

            if (start < str.length()) {
                list.add(str.substring(start));
            }
        }
        strArray = new String[list.size()];
        list.toArray(strArray);
        return strArray;
    }

    public static List splitFixStr(String str, int fixlen) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null && fixlen > 0) {
            int strlen = str.length();
            int i = 0;
            while (i < strlen) {
                if (i + fixlen >= strlen) {
                    fixlen = strlen - i;
                }
                list.add(str.substring(i, i + fixlen));
                i += fixlen;
            }
        }
        return list;
    }

    public static String[] splitStr2Array(String str, String separator) {
        List list = StringUtil.splitStr2List(str, separator);
        if (list != null && list.size() > 0) {
            String[] arr = new String[list.size()];
            list.toArray(arr);
            return arr;
        }
        return null;
    }

    public static List splitStr2List(String str, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringTokenizer stk = new StringTokenizer(str, separator);
            while (stk.hasMoreTokens()) {
                list.add(stk.nextToken().trim());
            }
        }
        return list;
    }

    public static String substring(String str, int startPos, int endPos) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        if (endPos <= 0 || startPos >= endPos) {
            return EMPTY;
        }
        if (endPos > strLen) {
            endPos = strLen;
        }
        return str.substring(startPos, endPos);
    }

    public static String substringAfter(String str, String searchStr) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        if (StringUtil.isEmpty(searchStr)) {
            return EMPTY;
        }
        int pos = str.indexOf(searchStr);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(pos + searchStr.length());
    }

    public static String substringBefore(String str, String searchStr) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        if (StringUtil.isEmpty(searchStr)) {
            return EMPTY;
        }
        int pos = str.indexOf(searchStr);
        if (pos == -1) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }

    public static String substringBetween(String str, String searchStr) {
        return StringUtil.substringBetween(str, searchStr, searchStr);
    }

    public static String substringBetween(String str, String starStr, String endStr) {
        int end;
        if (str == null || StringUtil.isEmpty(starStr) || StringUtil.isEmpty(endStr)) {
            return null;
        }
        int start = str.indexOf(starStr);
        if (start != -1 && (end = str.indexOf(endStr, start + starStr.length())) != -1) {
            return str.substring(start + starStr.length(), end);
        }
        return null;
    }

    public static String[] substringsBetween(String str, String starStr, String endStr) {
        if (str == null || StringUtil.isEmpty(starStr) || StringUtil.isEmpty(endStr)) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int openLen = starStr.length();
        int closeLen = endStr.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen) {
            int end;
            int start = str.indexOf(starStr, pos);
            if (start < 0 || (end = str.indexOf(endStr, start += openLen)) < 0) break;
            list.add(str.substring(start, end));
            pos = end + closeLen;
        }
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public static String trimLeft(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return str.substring(i);
            }
            ++i;
        }
        return null;
    }

    public static String trimRight(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int i = str.length() - 1;
        while (i > -1) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return str.substring(0, i + 1);
            }
            --i;
        }
        return null;
    }

    public static String trimSpace(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String trimChar(String str, char ch) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        while (i < strLen) {
            if (str.charAt(i) != ch) {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String maskLeft(String str, char ch, int length) {
        if (length == -1) {
            return StringUtil.repeat(ch, length);
        }
        return StringUtil.mask(str, ch, 0, length);
    }

    public static String maskRight(String str, char ch, int length) {
        if (length == -1) {
            return StringUtil.repeat(ch, length);
        }
        if (str != null) {
            return StringUtil.mask(str, ch, str.length() - length, -1);
        }
        return str;
    }

    public static String maskAfter(String str, char ch, int leftLength) {
        return StringUtil.mask(str, ch, leftLength, -1);
    }

    public static String maskBefore(String str, char ch, int rightLength) {
        if (str != null) {
            return StringUtil.mask(str, ch, 0, str.length() - rightLength);
        }
        return str;
    }

    public static String maskMiddle(String value, char character, int length) {
        if (value != null) {
            int len = value.length() - length;
            int begin = len / 2;
            int end = begin + length;
            return StringUtil.mask(value, character, begin, end);
        }
        return null;
    }

    public static String mask(String str, char ch, int beginPos, int endPos) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        int vLength = str.length();
        if (beginPos < 0) {
            beginPos = 0;
        }
        if (endPos < 0 || endPos > vLength) {
            endPos = vLength;
        }
        if (beginPos >= endPos) {
            return str;
        }
        if (beginPos == 0 && endPos == vLength) {
            return StringUtil.repeat(ch, vLength);
        }
        char[] charArray = str.toCharArray();
        int i = beginPos;
        while (i < endPos) {
            charArray[i] = ch;
            ++i;
        }
        return new String(charArray);
    }
}

