/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.NumberUtil;
import java.io.Serializable;

public class ShortObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7098378521733793214L;
    private short num;

    public ShortObject() {
        this.num = 0;
    }

    public ShortObject(short n) {
        this.num = n;
    }

    public ShortObject(Number n) {
        this.num = n != null ? n.shortValue() : (short)0;
    }

    public ShortObject(String n) {
        if (n != null) {
            try {
                this.num = Short.parseShort(n);
            }
            catch (Exception e) {
                this.num = 0;
            }
        }
    }

    public void increase() {
        this.num = (short)(this.num + 1);
    }

    public void increase(short n) {
        this.num = (short)(this.num + n);
    }

    public void increase(Object n) {
        this.num = (short)(this.num + NumberUtil.parseShort(n));
    }

    public void decrease() {
        this.num = (short)(this.num - 1);
    }

    public void decrease(short n) {
        this.num = (short)(this.num - n);
    }

    public void decrease(Object n) {
        this.num = (short)(this.num - NumberUtil.parseShort(n));
    }

    public void setValue(short n) {
        this.num = n;
    }

    public void setValue(Object n) {
        this.num = NumberUtil.parseShort(n);
    }

    public byte byteValue() {
        return (byte)this.num;
    }

    public double doubleValue() {
        return this.num;
    }

    public float floatValue() {
        return this.num;
    }

    public int intValue() {
        return this.num;
    }

    public long longValue() {
        return this.num;
    }

    public short shortValue() {
        return this.num;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShortObject) {
            return this.num == ((ShortObject)obj).shortValue();
        }
        return false;
    }

    public Short toShort() {
        return new Short(this.num);
    }

    public String toString() {
        return Short.toString(this.num);
    }

    public int compareTo(Object object) {
        ShortObject obj = (ShortObject)object;
        short thisNum = this.num;
        short compNum = obj.num;
        return thisNum < compNum ? -1 : (thisNum > compNum ? 1 : 0);
    }
}

