/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.lang.StringUtil;
import java.util.Random;

public class RandomUtil {
    private static final Random RANDOM = new Random();

    public static int random(int maxNum) {
        return RANDOM.nextInt(maxNum);
    }

    public static int random(int min, int max) {
        int diff = max - min;
        if (diff < 0) {
            diff = -diff;
        }
        if (diff == 0) {
            return min;
        }
        return RANDOM.nextInt(diff) + min;
    }

    public static String randomAlphabetic(int length) {
        if (length <= 0) {
            return "";
        }
        char[] array = new char[length];
        int i = 0;
        while (i < length) {
            array[i] = RANDOM.nextBoolean() ? (char)(RANDOM.nextInt(26) + 65) : (char)(RANDOM.nextInt(26) + 97);
            ++i;
        }
        return new String(array);
    }

    public static String randomNumeric(int length) {
        if (length <= 0) {
            return "";
        }
        char[] array = new char[length];
        int i = 0;
        while (i < length) {
            array[i] = (char)(RANDOM.nextInt(10) + 48);
            ++i;
        }
        return new String(array);
    }

    public static String randomAlphanumeric(int length) {
        if (length <= 0) {
            return "";
        }
        char[] array = new char[length];
        int i = 0;
        while (i < length) {
            switch (RANDOM.nextInt(3)) {
                case 0: {
                    array[i] = (char)(RANDOM.nextInt(26) + 65);
                    break;
                }
                case 1: {
                    array[i] = (char)(RANDOM.nextInt(26) + 97);
                    break;
                }
                case 2: {
                    array[i] = (char)(RANDOM.nextInt(10) + 48);
                }
            }
            ++i;
        }
        return new String(array);
    }

    public static Object[] randomObject(int count, Object[] object) {
        if (object == null) {
            return object;
        }
        int size = object.length;
        if (count <= 0 || size == 0) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] rndArray = new Object[count];
        int i = 0;
        while (i < count) {
            rndArray[i] = object[RANDOM.nextInt(size)];
            ++i;
        }
        return rndArray;
    }

    public static String randomString(char[] ch, int count) {
        if (ch == null) {
            return null;
        }
        int size = ch.length;
        if (count <= 0 || size == 0) {
            return "";
        }
        char[] array = new char[count];
        int i = 0;
        while (i < count) {
            array[i] = ch[RANDOM.nextInt(size)];
            ++i;
        }
        return new String(array);
    }

    public static String randomString(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        return RandomUtil.randomString(str.toCharArray(), str.length());
    }

    public static String randomString(String str, int length) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        return RandomUtil.randomString(str.toCharArray(), length);
    }
}

