/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.NumberUtil;
import java.io.Serializable;

public class LongObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1973361849128783356L;
    private long num;

    public LongObject() {
        this.num = 0L;
    }

    public LongObject(long n) {
        this.num = n;
    }

    public LongObject(Number n) {
        this.num = n != null ? n.longValue() : 0L;
    }

    public LongObject(String n) {
        if (n != null) {
            try {
                this.num = Long.parseLong(n);
            }
            catch (Exception e) {
                this.num = 0L;
            }
        }
    }

    public void increase() {
        ++this.num;
    }

    public void increase(long n) {
        this.num += n;
    }

    public void increase(Object n) {
        this.num += NumberUtil.parseLong(n);
    }

    public void decrease() {
        --this.num;
    }

    public void decrease(long n) {
        this.num -= n;
    }

    public void decrease(Object n) {
        this.num -= NumberUtil.parseLong(n);
    }

    public void setValue(long n) {
        this.num = n;
    }

    public void setValue(Object n) {
        this.num = NumberUtil.parseLong(n);
    }

    public byte byteValue() {
        return (byte)this.num;
    }

    public double doubleValue() {
        return this.num;
    }

    public float floatValue() {
        return this.num;
    }

    public int intValue() {
        return (int)this.num;
    }

    public long longValue() {
        return this.num;
    }

    public short shortValue() {
        return (short)this.num;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LongObject) {
            return this.num == ((LongObject)obj).longValue();
        }
        return false;
    }

    public Long toLong() {
        return new Long(this.num);
    }

    public String toString() {
        return Long.toString(this.num);
    }

    public int compareTo(Object object) {
        LongObject obj = (LongObject)object;
        long thisNum = this.num;
        long compNum = obj.num;
        return thisNum < compNum ? -1 : (thisNum > compNum ? 1 : 0);
    }
}

