/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.NumberUtil;
import java.io.Serializable;

public class IntObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = -7922063356280233129L;
    private int num;

    public IntObject() {
        this.num = 0;
    }

    public IntObject(int n) {
        this.num = n;
    }

    public IntObject(Number n) {
        this.num = n != null ? n.intValue() : 0;
    }

    public IntObject(String n) {
        if (n != null) {
            try {
                this.num = Integer.parseInt(n);
            }
            catch (Exception e) {
                this.num = 0;
            }
        }
    }

    public void increase() {
        ++this.num;
    }

    public void increase(int n) {
        this.num += n;
    }

    public void increase(Object n) {
        this.num += NumberUtil.parseInt(n);
    }

    public void decrease() {
        --this.num;
    }

    public void decrease(int n) {
        this.num -= n;
    }

    public void decrease(Object n) {
        this.num -= NumberUtil.parseInt(n);
    }

    public void setValue(int n) {
        this.num = n;
    }

    public void setValue(Object n) {
        this.num = NumberUtil.parseInt(n);
    }

    public byte byteValue() {
        return (byte)this.num;
    }

    public double doubleValue() {
        return this.num;
    }

    public float floatValue() {
        return this.num;
    }

    public int intValue() {
        return this.num;
    }

    public long longValue() {
        return this.num;
    }

    public short shortValue() {
        return (short)this.num;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IntObject) {
            return this.num == ((IntObject)obj).intValue();
        }
        return false;
    }

    public Integer toInteger() {
        return new Integer(this.num);
    }

    public String toString() {
        return Integer.toString(this.num);
    }

    public int compareTo(Object object) {
        IntObject obj = (IntObject)object;
        int thisNum = this.num;
        int compNum = obj.num;
        return thisNum < compNum ? -1 : (thisNum > compNum ? 1 : 0);
    }
}

