/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.io.FileUtil;
import com.tradevan.commons.io.StreamUtil;
import com.tradevan.commons.lang.ExceptionInfo;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.util.LogUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExceptionRegistry {
    private static Map exceptionMap = new HashMap();
    private static Set exceptionSet = new HashSet();
    private static Map extendException = new HashMap();

    public static void register(String exceptionXml) {
        InputStream is = null;
        try {
            try {
                if (!exceptionSet.contains(exceptionXml)) {
                    is = FileUtil.openInputStream(exceptionXml);
                    ExceptionRegistry.register(is);
                    exceptionSet.add(exceptionXml);
                }
            }
            catch (Exception e) {
                LogUtil.LOGGER.error("Fail to registry " + exceptionXml, e);
                StreamUtil.close(is);
            }
        }
        finally {
            StreamUtil.close(is);
        }
    }

    public static synchronized void register(InputStream is) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(is);
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Exception");
            int len = nodeList.getLength();
            int i = 0;
            while (i < len) {
                Node node = nodeList.item(i);
                String id = ExceptionRegistry.getAttribute(node, "id");
                String extendId = ExceptionRegistry.getAttribute(node, "extends");
                if (!StringUtil.isEmpty(extendId)) {
                    extendException.put(id, StringUtil.splitStr2List(extendId, ",;"));
                }
                ExceptionRegistry.initCode(id, node);
                ++i;
            }
        }
        catch (Exception e) {
            LogUtil.LOGGER.error("File to registry exception!", e);
        }
    }

    public static ExceptionInfo getExceptionInfo(String id, String code) {
        List extendId;
        ExceptionInfo exceptionInfo = null;
        Map codeMap = (Map)exceptionMap.get(id);
        if (codeMap != null) {
            exceptionInfo = (ExceptionInfo)codeMap.get(code);
        }
        if (exceptionInfo == null && (extendId = (List)extendException.get(id)) != null) {
            int i = 0;
            while (i < extendId.size()) {
                String exceptionId = (String)extendId.get(i);
                if (exceptionMap.get(exceptionId) != null && !id.equals(exceptionId)) {
                    exceptionInfo = ExceptionRegistry.getExtendException(exceptionId, code, id);
                    break;
                }
                ++i;
            }
        }
        exceptionInfo = exceptionInfo == null ? new ExceptionInfo(id, code, null, null) : new ExceptionInfo(id, code, exceptionInfo.getMessage(), exceptionInfo.getInstruction());
        return exceptionInfo;
    }

    private static ExceptionInfo getExtendException(String id, String code, String childId) {
        List extendId;
        ExceptionInfo exceptionInfo = null;
        Map codeMap = (Map)exceptionMap.get(id);
        if (codeMap == null) {
            return null;
        }
        exceptionInfo = (ExceptionInfo)codeMap.get(code);
        if (exceptionInfo == null && (extendId = (List)extendException.get(id)) != null) {
            int i = 0;
            while (i < extendId.size()) {
                String exceptionId = (String)extendId.get(i);
                if (childId.indexOf(exceptionId) <= -1 && exceptionMap.get(exceptionId) != null && !id.equals(exceptionId)) {
                    exceptionInfo = ExceptionRegistry.getExtendException(exceptionId, code, String.valueOf(childId) + "," + exceptionId);
                    break;
                }
                ++i;
            }
        }
        return exceptionInfo;
    }

    public static ExceptionInfo getExceptionInfo(String id, String code, String[] args) {
        ExceptionInfo exceptionInfo = ExceptionRegistry.getExceptionInfo(id, code);
        exceptionInfo.setArguments(args);
        return exceptionInfo;
    }

    private static void initCode(String exceptionId, Node exceptionNode) {
        NodeList codeNodeList = exceptionNode.getChildNodes();
        int j = 0;
        while (j < codeNodeList.getLength()) {
            String codeValue;
            Node codeNode = codeNodeList.item(j);
            if (codeNode.getNodeType() == 1 && "Code".equals(codeNode.getNodeName()) && (codeValue = ExceptionRegistry.getAttribute(codeNode, "value")) != null) {
                String message = null;
                String instruction = null;
                NodeList childNode = codeNode.getChildNodes();
                int k = 0;
                while (k < childNode.getLength()) {
                    Node node = childNode.item(k);
                    if ("Message".equals(node.getNodeName())) {
                        message = ExceptionRegistry.getElementValue(node);
                    } else if ("Instruction".equals(node.getNodeName())) {
                        instruction = ExceptionRegistry.getElementValue(node);
                    }
                    ++k;
                }
                ExceptionInfo exceptionInfo = new ExceptionInfo(exceptionId, codeValue, message, instruction);
                ExceptionRegistry.addExceptionInfo(exceptionInfo);
            }
            ++j;
        }
    }

    private static void addExceptionInfo(ExceptionInfo exceptionInfo) {
        HashMap<String, ExceptionInfo> codeMap = (HashMap<String, ExceptionInfo>)exceptionMap.get(exceptionInfo.getId());
        if (codeMap == null) {
            codeMap = new HashMap<String, ExceptionInfo>();
            exceptionMap.put(exceptionInfo.getId(), codeMap);
        }
        codeMap.put(exceptionInfo.getCode(), exceptionInfo);
    }

    private static String getAttribute(Node node, String attrName) {
        Node attr;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (attr = attrs.getNamedItem(attrName)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    private static String getElementValue(Node node) {
        Node firstNode = node.getFirstChild();
        if (firstNode != null) {
            return firstNode.getNodeValue();
        }
        return null;
    }
}

