/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import java.io.Serializable;
import java.text.MessageFormat;

public class ExceptionInfo
implements Serializable {
    private static final long serialVersionUID = 2617909200814250011L;
    private static final String MESSAGE_FORMAT = "[{0}-{1}]: {2} ({3})";
    private String exceptionId = null;
    private String exceptionCode = null;
    private String message = null;
    private String instruction = null;
    private String[] messageArgs = null;

    public ExceptionInfo(String exceptionId, String exceptionCode, String message, String instruction) {
        this.exceptionId = exceptionId;
        this.exceptionCode = exceptionCode;
        this.message = message;
        this.instruction = instruction;
    }

    public void setArguments(String[] args) {
        this.messageArgs = args;
    }

    public String getId() {
        return this.exceptionId;
    }

    public String getCode() {
        return this.exceptionCode;
    }

    public String getMessage() {
        if (this.messageArgs != null && this.message != null) {
            return MessageFormat.format(this.message, this.messageArgs);
        }
        return this.message;
    }

    public String getInstruction() {
        if (this.messageArgs != null && this.instruction != null) {
            return MessageFormat.format(this.instruction, this.messageArgs);
        }
        return this.instruction;
    }

    public String getFormatMessage(String format) {
        String msg = this.getMessage();
        String inst = this.getInstruction();
        Object[] s = new String[]{this.exceptionId, this.exceptionCode, msg, inst};
        return MessageFormat.format(format, s);
    }

    public String getFormatMessage() {
        return this.getFormatMessage(MESSAGE_FORMAT);
    }

    public String toString() {
        return String.valueOf(this.exceptionId != null ? String.valueOf(this.exceptionId) + "-" : "") + (this.exceptionCode != null ? String.valueOf(this.exceptionCode) + ": " : "") + this.getMessage();
    }
}

