/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.NumberUtil;
import java.io.Serializable;

public class DoubleObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = -2203097521255350519L;
    private double num;

    public DoubleObject() {
        this.num = 0.0;
    }

    public DoubleObject(double n) {
        this.num = n;
    }

    public DoubleObject(Number n) {
        this.num = n != null ? n.doubleValue() : 0.0;
    }

    public DoubleObject(String n) {
        if (n != null) {
            try {
                this.num = Double.parseDouble(n);
            }
            catch (Exception e) {
                this.num = 0.0;
            }
        }
    }

    public void increase() {
        this.num += 1.0;
    }

    public void increase(double n) {
        this.num += n;
    }

    public void increase(Object n) {
        this.num += NumberUtil.parseDouble(n);
    }

    public void decrease() {
        this.num -= 1.0;
    }

    public void decrease(double n) {
        this.num -= n;
    }

    public void decrease(Object n) {
        this.num -= NumberUtil.parseDouble(n);
    }

    public void setValue(double n) {
        this.num = n;
    }

    public void setValue(Object n) {
        this.num = NumberUtil.parseDouble(n);
    }

    public byte byteValue() {
        return (byte)this.num;
    }

    public double doubleValue() {
        return this.num;
    }

    public float floatValue() {
        return (float)this.num;
    }

    public int intValue() {
        return (int)this.num;
    }

    public long longValue() {
        return (long)this.num;
    }

    public short shortValue() {
        return (short)this.num;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DoubleObject) {
            return this.num == ((DoubleObject)obj).doubleValue();
        }
        return false;
    }

    public Double toDouble() {
        return new Double(this.num);
    }

    public String toString() {
        return Double.toString(this.num);
    }

    public int compareTo(Object object) {
        DoubleObject obj = (DoubleObject)object;
        double thisNum = this.num;
        double compNum = obj.num;
        return thisNum < compNum ? -1 : (thisNum > compNum ? 1 : 0);
    }
}

