/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateTimeUtil {
    public static boolean isLeapYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static boolean isLeapYear(String date, String dateFormat) throws Exception {
        return DateTimeUtil.isLeapYear(DateTimeUtil.parseDateTime(date, dateFormat));
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateTimeUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static String getCurrentDateTime(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static Date getAddedDateTime(String addDateTime) {
        Calendar cal = Calendar.getInstance();
        return DateTimeUtil.addDateTime(cal.getTime(), addDateTime);
    }

    public static Date addDateTime(Date date, String addDateTime) {
        if (date == null) {
            return date;
        }
        if (addDateTime != null && !"".equals(addDateTime)) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            List list = StringUtil.splitStr2List(addDateTime, ",;");
            int i = 0;
            while (i < list.size()) {
                String s = ((String)list.get(i)).trim();
                int j = s.indexOf(":");
                if (j != -1) {
                    int n = Integer.parseInt(s.substring(j + 1));
                    switch (s.charAt(0)) {
                        case 'Y': {
                            cal.add(1, n);
                            break;
                        }
                        case 'M': {
                            cal.add(2, n);
                            break;
                        }
                        case 'D': {
                            cal.add(5, n);
                            break;
                        }
                        case 'h': {
                            cal.add(10, n);
                            break;
                        }
                        case 'm': {
                            cal.add(12, n);
                            break;
                        }
                        case 's': {
                            cal.add(13, n);
                            break;
                        }
                        case 'W': {
                            cal.add(4, n);
                        }
                    }
                }
                ++i;
            }
            date = cal.getTime();
        }
        return date;
    }

    public static String getAddedDateTime(String addDateTime, String format) {
        Date date = DateTimeUtil.getAddedDateTime(addDateTime);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String addDateTime(Date date, String addDateTime, String format) {
        date = DateTimeUtil.addDateTime(date, addDateTime);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static Date getAddedDateTime(int year, int month, int day, int hour, int min, int second) {
        Calendar cal = Calendar.getInstance();
        if (year != 0) {
            cal.add(1, year);
        }
        if (month != 0) {
            cal.add(2, month);
        }
        if (day != 0) {
            cal.add(5, day);
        }
        if (hour != 0) {
            cal.add(10, hour);
        }
        if (min != 0) {
            cal.add(12, min);
        }
        if (second != 0) {
            cal.add(13, second);
        }
        return cal.getTime();
    }

    public static String getAddedDateTime(String format, int year, int month, int day, int hour, int min, int second) {
        Date currentDate = DateTimeUtil.getAddedDateTime(year, month, day, hour, min, second);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String dateTimeStamp = formatter.format(currentDate);
        return dateTimeStamp;
    }

    public static String transferFormat(String datetime, String srcFormat, String targetFormat) {
        try {
            SimpleDateFormat srcSdf = new SimpleDateFormat(srcFormat);
            SimpleDateFormat targetSdf = new SimpleDateFormat(targetFormat);
            datetime = targetSdf.format(srcSdf.parse(datetime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return datetime;
    }

    public static Date getDateOfWeek(String addDateTime, int day) {
        return DateTimeUtil.getDateOfWeek(DateTimeUtil.getAddedDateTime(addDateTime), day);
    }

    public static Date getDateOfWeek(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, day);
        return cal.getTime();
    }

    public static Date getDateOfThisWeek(int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, day);
        return cal.getTime();
    }

    public static Date parseDateTime(String dateStr, String format) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(dateStr);
    }

    public static int getDays(int year, int month) {
        if (month > 12 || month < 1) {
            throw new IllegalArgumentException("month must between 1 - 12");
        }
        int[] day = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if ((year % 4 == 0 && year % 100 != 0 || year % 400 == 0) && month == 2) {
            return day[month - 1] + 1;
        }
        return day[month - 1];
    }
}

