/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.CommonBaseException;
import com.tradevan.commons.CommonRuntimeException;
import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.commons.util.LogUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassUtil {
    private static final String EXCEPTION_ID = "ClassUtil";
    private static Map primitiveClass = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz, Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz2, Byte.TYPE);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz3, Character.TYPE);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz4, Double.TYPE);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz5, Float.TYPE);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz6, Integer.TYPE);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz7, Long.TYPE);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        primitiveClass.put(clazz8, Short.TYPE);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader;
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null) {
            loader = contextLoader;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("com.tradevan.commons.lang.ClassUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            loader = clazz.getClassLoader();
        }
        return loader;
    }

    public static Class getClass(String className) {
        return ClassUtil.getClass(className, true);
    }

    public static Class getClass(String className, boolean init) {
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        Class<?> clazz = null;
        try {
            ClassLoader loader = ClassUtil.getClassLoader();
            clazz = Class.forName(className, init, loader);
        }
        catch (Exception e) {
            LogUtil.LOGGER.error("Fail to load class " + className);
        }
        return clazz;
    }

    public static Class getClass(ClassLoader classLoader, String className) {
        return ClassUtil.getClass(classLoader, className, true);
    }

    public static Class getClass(ClassLoader classLoader, String className, boolean init) {
        if (classLoader == null || StringUtil.isEmpty(className)) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, init, classLoader);
        }
        catch (Exception e) {
            LogUtil.LOGGER.error("Fail to load class " + className);
        }
        return clazz;
    }

    public static Class[] getClass(Object[] objs) {
        Class[] obj_type = null;
        if (objs != null) {
            obj_type = new Class[objs.length];
            int i = 0;
            while (i < objs.length) {
                if (objs[i] != null) {
                    obj_type[i] = objs[i].getClass();
                }
                ++i;
            }
        }
        return obj_type;
    }

    public static Class[] getClass(String[] className) {
        Class[] classArray = null;
        if (className != null) {
            classArray = new Class[className.length];
            int i = 0;
            while (i < classArray.length) {
                classArray[i] = ClassUtil.getClass(className[i]);
                ++i;
            }
        }
        return classArray;
    }

    public static Class[] getClass(ClassLoader classLoader, String[] className) {
        Class[] classArray = null;
        if (className != null) {
            classArray = new Class[className.length];
            int i = 0;
            while (i < classArray.length) {
                classArray[i] = ClassUtil.getClass(classLoader, className[i]);
                ++i;
            }
        }
        return classArray;
    }

    public static Method getPublicMethod(Class cls, String methodName, Class[] parameterTypes) {
        Method publicMethod = null;
        try {
            publicMethod = cls.getMethod(methodName, parameterTypes);
            if (Modifier.isPublic(publicMethod.getDeclaringClass().getModifiers())) {
                return publicMethod;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList candidateClasses = new ArrayList();
        candidateClasses.addAll(ClassUtil.getAllInterface(cls));
        candidateClasses.addAll(ClassUtil.getAllSuperClass(cls));
        Iterator it = candidateClasses.iterator();
        while (it.hasNext()) {
            Method candidateMethod;
            Class candidateClass = (Class)it.next();
            if (!Modifier.isPublic(candidateClass.getModifiers())) continue;
            try {
                candidateMethod = candidateClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            if (!Modifier.isPublic(candidateMethod.getDeclaringClass().getModifiers())) continue;
            publicMethod = candidateMethod;
            break;
        }
        return publicMethod;
    }

    public static List getAllInterface(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Class> list = new ArrayList<Class>();
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                List superInterfaces = ClassUtil.getAllInterface(interfaces[i]);
                Iterator it = superInterfaces.iterator();
                while (it.hasNext()) {
                    Class intface = (Class)it.next();
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
                ++i;
            }
            cls = cls.getSuperclass();
        }
        return list;
    }

    public static List getAllSuperClass(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        Class superclass = cls.getSuperclass();
        while (superclass != null) {
            classes.add(superclass);
            superclass = superclass.getSuperclass();
        }
        return classes;
    }

    public static String getPackageName(Class cls) {
        if (cls == null) {
            return "";
        }
        return ClassUtil.getPackageName(cls.getName());
    }

    public static String getPackageName(Object object) {
        if (object == null) {
            return "";
        }
        return ClassUtil.getPackageName(object.getClass().getName());
    }

    public static String getPackageName(String className) {
        if (className == null) {
            return "";
        }
        int i = className.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return className.substring(0, i);
    }

    public static Object newInstance(String className) {
        ClassLoader classLoader = ClassUtil.getClassLoader();
        return ClassUtil.newInstance(classLoader, className);
    }

    public static Object newInstance(ClassLoader classLoader, String className) {
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        Object insObj = null;
        Class classCreator = ClassUtil.getClass(classLoader, className);
        if (classCreator != null) {
            try {
                insObj = classCreator.newInstance();
            }
            catch (Exception e) {
                LogUtil.LOGGER.error("Fail to instant object for " + className);
            }
        }
        return insObj;
    }

    public static Object newInstance(String className, Class[] argsClass, Object[] args) {
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        ClassLoader classLoader = ClassUtil.getClassLoader();
        return ClassUtil.newInstance(classLoader, className, argsClass, args);
    }

    public static Object newInstance(ClassLoader classLoader, String className, Class[] argsClass, Object[] args) {
        Object insObj = null;
        Class classCreator = ClassUtil.getClass(classLoader, className);
        if (classCreator != null) {
            try {
                Constructor class_constructor = classCreator.getConstructor(argsClass);
                insObj = class_constructor.newInstance(args);
            }
            catch (Exception e) {
                LogUtil.LOGGER.error("Fail to instant object for " + className + " because of " + e.getMessage());
            }
        }
        return insObj;
    }

    public static Object invoke(Object obj, String methodName, Object[] args) throws CommonBaseException {
        if (obj == null || StringUtil.isEmpty(methodName)) {
            throw new CommonRuntimeException(EXCEPTION_ID, "40201");
        }
        Object returnObj = null;
        try {
            if (obj != null) {
                Class class_creator = obj.getClass();
                if (obj instanceof Class) {
                    class_creator = (Class)obj;
                }
                Class[] args_type = ClassUtil.getClass(args);
                Method method_invoker = class_creator.getMethod(methodName, args_type);
                returnObj = method_invoker.invoke(obj, args);
            }
        }
        catch (Exception e) {
            String[] msgArgs = new String[]{methodName, e.getMessage()};
            CommonBaseException cbe = new CommonBaseException(EXCEPTION_ID, "42201", msgArgs);
            cbe.initCause(e);
            throw cbe;
        }
        return returnObj;
    }

    public static Object invoke(String className, String methodName, Object[] args) throws CommonBaseException {
        Object returnObj;
        block4: {
            if (StringUtil.isEmpty(className) || StringUtil.isEmpty(methodName)) {
                throw new CommonRuntimeException("No object or method could be invoked!");
            }
            returnObj = null;
            try {
                Class class_creator = ClassUtil.getClass(className);
                if (class_creator != null) {
                    Class[] args_type = ClassUtil.getClass(args);
                    Method method_invoker = class_creator.getMethod(methodName, args_type);
                    returnObj = Modifier.isStatic(method_invoker.getModifiers()) ? method_invoker.invoke((Object)class_creator, args) : method_invoker.invoke(class_creator.newInstance(), args);
                    break block4;
                }
                throw new CommonBaseException("Class was not found: " + className);
            }
            catch (Exception e) {
                throw new CommonBaseException("Fail to invoke " + methodName + " of " + className + "! " + e.getMessage());
            }
        }
        return returnObj;
    }

    public static Object invoke(String className, String methodName, Class[] args_type, Object[] args) throws CommonBaseException {
        Object returnObj;
        block4: {
            if (StringUtil.isEmpty(className) || StringUtil.isEmpty(methodName)) {
                throw new CommonRuntimeException("No object or method could be invoked!");
            }
            returnObj = null;
            try {
                Class class_creator = ClassUtil.getClass(className);
                if (class_creator != null) {
                    Method method_invoker = class_creator.getMethod(methodName, args_type);
                    returnObj = Modifier.isStatic(method_invoker.getModifiers()) ? method_invoker.invoke((Object)class_creator, args) : method_invoker.invoke(class_creator.newInstance(), args);
                    break block4;
                }
                throw new CommonBaseException("Class was not found: " + className);
            }
            catch (Exception e) {
                throw new CommonBaseException("Fail to invoke " + methodName + " of " + className + "! " + e.getMessage());
            }
        }
        return returnObj;
    }

    public static Object invoke(Object obj, String methodName, Class[] args_type, Object[] args) throws CommonBaseException {
        if (obj == null || StringUtil.isEmpty(methodName)) {
            throw new CommonRuntimeException(EXCEPTION_ID, "40201");
        }
        Object returnObj = null;
        try {
            if (obj != null) {
                Class class_creator = obj.getClass();
                if (obj instanceof Class) {
                    class_creator = (Class)obj;
                }
                Method method_invoker = class_creator.getMethod(methodName, args_type);
                returnObj = method_invoker.invoke(obj, args);
            }
        }
        catch (Exception e) {
            String[] msgArgs = new String[]{methodName, e.getMessage()};
            CommonBaseException cbe = new CommonBaseException(EXCEPTION_ID, "42201", msgArgs);
            cbe.initCause(e);
            throw cbe;
        }
        return returnObj;
    }

    public static void inject(Object target, Map valueMap) {
        if (target == null || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        Class<?> cls = target.getClass();
        Iterator ito = valueMap.entrySet().iterator();
        String key = "";
        String methodName = "";
        while (ito.hasNext()) {
            Method method;
            Object value;
            block8: {
                Map.Entry entry = ito.next();
                key = (String)entry.getKey();
                methodName = ClassUtil.getSetterName(key);
                value = entry.getValue();
                if (value == null) continue;
                method = null;
                try {
                    Class[] argType = new Class[]{value.getClass()};
                    method = cls.getMethod(methodName, argType);
                }
                catch (NoSuchMethodException me) {
                    Class primitive = (Class)primitiveClass.get(value.getClass());
                    if (primitive == null) break block8;
                    try {
                        method = cls.getMethod(methodName, primitive);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (method == null) continue;
            try {
                Object[] args = new Object[]{value};
                method.invoke(target, args);
            }
            catch (Exception e) {
                LogUtil.LOGGER.warn("Fail to set " + value + " to " + methodName + ". " + e);
            }
        }
    }

    public static Map getProperties(Object target, String[] propertyName) {
        if (target == null || ArrayUtil.isEmpty(propertyName)) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        Class<?> cls = target.getClass();
        String methodName = "";
        Method method = null;
        int i = 0;
        while (i < propertyName.length) {
            try {
                methodName = ClassUtil.getGetterName(propertyName[i]);
                method = cls.getMethod(methodName, null);
                if (Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    values.put(propertyName[i], method.invoke(target, null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return values;
    }

    public static String getGetterName(String attrName) {
        if (StringUtil.isEmpty(attrName)) {
            return attrName;
        }
        return ClassUtil.normalize("get", attrName);
    }

    public static String getSetterName(String attrName) {
        if (StringUtil.isEmpty(attrName)) {
            return attrName;
        }
        return ClassUtil.normalize("set", attrName);
    }

    private static String normalize(String prefix, String attrName) {
        int strLen = attrName.length();
        StringBuffer sb = new StringBuffer(strLen);
        sb.append(prefix);
        String delimiters = " _-.";
        boolean capitalizeNext = true;
        int i = 0;
        while (i < strLen) {
            char ch = attrName.charAt(i);
            if (delimiters.indexOf(ch) > -1) {
                capitalizeNext = true;
            } else if (capitalizeNext) {
                sb.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

