/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import java.io.UnsupportedEncodingException;

public class CharUtil {
    public static final char NULL_CHAR = '\u0000';
    private static final String UNICODE_PREFIX = "\\u";

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiAlpha(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    public static boolean isAsciiNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static String toUnicode(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return UNICODE_PREFIX + Integer.toHexString(ch);
    }

    public static String toUnicode(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(strLen * 6);
        int i = 0;
        while (i < strLen) {
            sb.append(CharUtil.toUnicode(str.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static char unicodeToChar(String unicode) {
        if (unicode == null || unicode.length() != 6) {
            return '\u0000';
        }
        if (unicode.startsWith(UNICODE_PREFIX)) {
            try {
                String hexCode = unicode.substring(2, 6);
                int code = Integer.parseInt(hexCode, 16);
                return (char)code;
            }
            catch (Exception e) {
                return '\u0000';
            }
        }
        return '\u0000';
    }

    /*
     * Unable to fully structure code
     */
    public static String unicodeToStr(String unicode) {
        block6: {
            if (unicode == null || (strLen = unicode.length()) == 0) {
                return unicode;
            }
            sb = new StringBuffer(strLen / 6);
            pos = unicode.indexOf("\\u");
            if (pos <= 0) break block6;
            sb.append(unicode.substring(0, pos));
            ** GOTO lbl21
        }
        if (pos != -1) ** GOTO lbl21
        return unicode;
        {
            while ((start = unicode.indexOf("\\u", pos)) >= 0) {
                if (pos < start) {
                    sb.append(unicode.substring(pos, start));
                }
                if (start + 6 <= strLen) {
                    hexCode = unicode.substring(start + 2, start + 6);
                    sb.append((char)Integer.parseInt(hexCode, 16));
                    pos = start + 6;
                }
lbl21:
                // 5 sources

                if (pos < strLen) continue;
            }
        }
        if (pos < strLen) {
            sb.append(unicode.substring(pos));
        }
        return sb.toString();
    }

    public static String toHex(char ch) {
        return Integer.toHexString(ch);
    }

    public static String toHex(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char[] ch = str.toCharArray();
        StringBuffer sb = new StringBuffer(strLen * 2);
        int i = 0;
        while (i < strLen) {
            sb.append(Integer.toHexString(ch[i]));
            ++i;
        }
        return sb.toString();
    }

    public static int toIntValue(char ch) {
        if (ch < '0' || ch > '9') {
            throw new IllegalArgumentException("The character " + ch + " is not in the range '0' - '9'");
        }
        return ch - 48;
    }

    public static byte[] getBytes(char ch) {
        if (ch < '\u0100') {
            byte[] array = new byte[]{(byte)ch};
            return array;
        }
        char[] array = new char[]{ch};
        String str = new String(array);
        return str.getBytes();
    }

    public static char toChar(byte[] array) {
        if (array == null || array.length == 0) {
            return '\u0000';
        }
        if (array.length == 1) {
            return (char)array[0];
        }
        String str = new String(array);
        char[] chArray = str.toCharArray();
        return chArray[0];
    }

    public static char toChar(byte[] array, String encoding) throws UnsupportedEncodingException {
        if (array == null || array.length == 0) {
            return '\u0000';
        }
        if (array.length == 1) {
            return (char)array[0];
        }
        String str = new String(array, encoding);
        char[] chArray = str.toCharArray();
        return chArray[0];
    }

    public static byte[] toByteArray(char[] array) {
        String str = new String(array);
        return str.getBytes();
    }

    public static byte[] toByteArray(char[] array, String encoding) throws UnsupportedEncodingException {
        String str = new String(array);
        return str.getBytes(encoding);
    }

    public static char[] toCharArray(byte[] array) {
        String str = new String(array);
        return str.toCharArray();
    }

    public static char[] toCharArray(byte[] array, String encoding) throws UnsupportedEncodingException {
        String str = new String(array, encoding);
        return str.toCharArray();
    }
}

