/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.lang;

import com.tradevan.commons.lang.NumberUtil;
import java.io.Serializable;

public class ByteObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = -2719239605181392494L;
    private byte num;

    public ByteObject() {
        this.num = 0;
    }

    public ByteObject(byte n) {
        this.num = n;
    }

    public ByteObject(Number n) {
        this.num = n != null ? n.byteValue() : (byte)0;
    }

    public ByteObject(String n) {
        if (n != null) {
            try {
                this.num = Byte.parseByte(n);
            }
            catch (Exception e) {
                this.num = 0;
            }
        }
    }

    public void increase() {
        this.num = (byte)(this.num + 1);
    }

    public void increase(byte n) {
        this.num = (byte)(this.num + n);
    }

    public void increase(Object n) {
        this.num = (byte)(this.num + NumberUtil.parseByte(n));
    }

    public void decrease() {
        this.num = (byte)(this.num - 1);
    }

    public void decrease(byte n) {
        this.num = (byte)(this.num - n);
    }

    public void decrease(Object n) {
        this.num = (byte)(this.num - NumberUtil.parseByte(n));
    }

    public void setValue(byte n) {
        this.num = n;
    }

    public void setValue(Object n) {
        this.num = NumberUtil.parseByte(n);
    }

    public byte byteValue() {
        return this.num;
    }

    public double doubleValue() {
        return this.num;
    }

    public float floatValue() {
        return this.num;
    }

    public int intValue() {
        return this.num;
    }

    public long longValue() {
        return this.num;
    }

    public short shortValue() {
        return this.num;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ByteObject) {
            return this.num == ((ByteObject)obj).byteValue();
        }
        return false;
    }

    public Byte toByte() {
        return new Byte(this.num);
    }

    public String toString() {
        return Byte.toString(this.num);
    }

    public int compareTo(Object object) {
        ByteObject obj = (ByteObject)object;
        byte thisNum = this.num;
        byte compNum = obj.num;
        return thisNum < compNum ? -1 : (thisNum > compNum ? 1 : 0);
    }
}

