/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StreamUtil {
    public static final String LINE_ENDING;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    static {
        StringWriter sw = new StringWriter(4);
        PrintWriter ps = new PrintWriter(sw);
        ps.println();
        ps.close();
        LINE_ENDING = sw.toString();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, Writer output) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return StreamUtil.copy((Reader)reader, output);
    }

    public static long copy(InputStream input, Writer output, String encoding) throws IOException {
        InputStreamReader reader = encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, encoding);
        return StreamUtil.copy((Reader)reader, output);
    }

    public static long copy(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        return StreamUtil.copy(input, (Writer)writer);
    }

    public static long copy(Reader input, OutputStream output, String encoding) throws IOException {
        OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(output) : new OutputStreamWriter(output, encoding);
        return StreamUtil.copy(input, (Writer)writer);
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        output.flush();
        return count;
    }

    public static List readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return StreamUtil.readLines(reader);
    }

    public static List readLines(InputStream input, String encoding) throws IOException {
        if (encoding == null) {
            return StreamUtil.readLines(input);
        }
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return StreamUtil.readLines(reader);
    }

    public static List readLines(Reader input) throws IOException {
        BufferedReader reader = null;
        reader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtil.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String encoding) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StreamUtil.copy(input, output, encoding);
        return output.toByteArray();
    }

    public static char[] toCharArray(InputStream input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        StreamUtil.copy(input, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream input, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        StreamUtil.copy(input, output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        StreamUtil.copy(input, (Writer)output);
        return output.toCharArray();
    }

    public static InputStream toInputStream(String str) throws IOException {
        byte[] bytes = str.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String str, String encoding) throws IOException {
        if (str == null) {
            return null;
        }
        if (encoding != null) {
            return new ByteArrayInputStream(str.getBytes(encoding));
        }
        return new ByteArrayInputStream(str.getBytes());
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        StreamUtil.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String encoding) throws IOException {
        StringWriter sw = new StringWriter();
        StreamUtil.copy(input, sw, encoding);
        return sw.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        StreamUtil.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null && output != null) {
            output.write(data);
        }
    }

    public static void write(byte[] data, Writer output) throws IOException {
        if (data != null && output != null) {
            output.write(new String(data));
        }
    }

    public static void write(byte[] data, Writer output, String encoding) throws IOException {
        if (data != null && output != null) {
            if (encoding == null) {
                StreamUtil.write(data, output);
            } else {
                output.write(new String(data, encoding));
            }
        }
    }

    public static void write(char[] data, OutputStream output) throws IOException {
        if (data != null && output != null) {
            output.write(new String(data).getBytes());
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        if (data != null && output != null) {
            if (encoding == null) {
                StreamUtil.write(data, output);
            } else {
                output.write(new String(data).getBytes(encoding));
            }
        }
    }

    public static void write(char[] data, Writer output) throws IOException {
        if (data != null && output != null) {
            output.write(data);
        }
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null && output != null) {
            output.write(data.getBytes());
        }
    }

    public static void write(String data, OutputStream output, String encoding) throws IOException {
        if (data != null && output != null) {
            if (encoding == null) {
                StreamUtil.write(data, output);
            } else {
                output.write(data.getBytes(encoding));
            }
        }
    }

    public static void write(String data, Writer output) throws IOException {
        if (data != null && output != null) {
            output.write(data);
        }
    }

    public static void writeLines(Collection data, OutputStream output) throws IOException {
        if (data == null || output == null) {
            return;
        }
        Iterator it = data.iterator();
        while (it.hasNext()) {
            Object line = it.next();
            if (line != null) {
                output.write(line.toString().getBytes());
            }
            output.write(LINE_ENDING.getBytes());
        }
    }

    public static void writeLines(Collection data, OutputStream output, String encoding) throws IOException {
        StreamUtil.writeLines(data, output, encoding, LINE_ENDING);
    }

    public static void writeLines(Collection data, OutputStream output, String encoding, String lineEnding) throws IOException {
        if (data == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_ENDING;
        }
        Iterator it = data.iterator();
        while (it.hasNext()) {
            Object line = it.next();
            if (line != null) {
                output.write(line.toString().getBytes(encoding));
            }
            output.write(lineEnding.getBytes());
        }
    }

    public static void close(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

