/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.io;

import com.tradevan.commons.io.FileUtil;
import com.tradevan.commons.io.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class ObjectUtil {
    public static void writeObject(Serializable obj, OutputStream output) throws IOException {
        if (obj == null) {
            return;
        }
        if (output == null) {
            throw new NullPointerException("OutputStream must be specified!");
        }
        ObjectOutputStream objectOut = null;
        objectOut = output instanceof ObjectOutputStream ? (ObjectOutputStream)output : new ObjectOutputStream(output);
        objectOut.writeObject(obj);
        objectOut.flush();
    }

    public static void writeObjects(Serializable[] objs, OutputStream output) throws IOException {
        if (objs == null) {
            return;
        }
        if (output == null) {
            throw new NullPointerException("OutputStream must be specified!");
        }
        ObjectOutputStream objectOut = null;
        objectOut = output instanceof ObjectOutputStream ? (ObjectOutputStream)output : new ObjectOutputStream(output);
        int i = 0;
        while (i < objs.length) {
            objectOut.writeObject(objs[i]);
            ++i;
        }
        objectOut.flush();
    }

    public static void writeObject(Serializable obj, File file) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, false);
            ObjectUtil.writeObject(obj, out);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static void writeObjects(Serializable[] objs, File file) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, false);
            ObjectUtil.writeObjects(objs, out);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static Object readObject(InputStream input) throws IOException, ClassNotFoundException {
        if (input == null) {
            throw new NullPointerException("InputStream must be specified!");
        }
        Object object = null;
        ObjectInputStream objectIn = null;
        objectIn = input instanceof ObjectInputStream ? (ObjectInputStream)input : new ObjectInputStream(input);
        object = objectIn.readObject();
        return object;
    }

    public static Object[] readObjects(InputStream input) throws IOException, ClassNotFoundException {
        if (input == null) {
            throw new NullPointerException("InputStream must be specified!");
        }
        ObjectInputStream objectIn = null;
        objectIn = input instanceof ObjectInputStream ? (ObjectInputStream)input : new ObjectInputStream(input);
        ArrayList<Object> objectList = new ArrayList<Object>();
        Object object = null;
        try {
            while ((object = objectIn.readObject()) != null) {
                objectList.add(object);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        Object[] objects = new Object[objectList.size()];
        objectList.toArray(objects);
        return objects;
    }

    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        Object object = null;
        InputStream input = null;
        try {
            input = FileUtil.openInputStream(file);
            object = ObjectUtil.readObject(input);
        }
        finally {
            StreamUtil.close(input);
        }
        return object;
    }

    public static Object[] readObjects(File file) throws IOException, ClassNotFoundException {
        Object[] object = null;
        InputStream input = null;
        try {
            input = FileUtil.openInputStream(file);
            object = ObjectUtil.readObjects(input);
        }
        finally {
            StreamUtil.close(input);
        }
        return object;
    }

    public static Object clone(Serializable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectUtil.writeObject(obj, out);
        ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
        try {
            return ObjectUtil.readObject(input);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

