/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.io;

import com.tradevan.commons.io.CommonsIOException;
import com.tradevan.commons.io.FileListFilter;
import com.tradevan.commons.io.FileSystemUtil;
import com.tradevan.commons.io.StreamUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Stack;

public class FileUtil {
    public static final String UNIT_KB = "KB";
    public static final String UNIT_MB = "MB";
    public static final String UNIT_GB = "GB";
    public static final String UNIT_TB = "TB";
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FileUtil.isWindows() ? (char)47 : (char)92;
    static /* synthetic */ Class class$0;

    public static boolean isWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    public static int copy(File src, File dest, boolean overwrite, boolean preserveFileDate) throws IOException {
        if (src == null || dest == null) {
            throw new NullPointerException("Source or destination is null!");
        }
        if (!src.exists()) {
            throw new FileNotFoundException(src + " does not exist!");
        }
        if (src.isFile()) {
            FileUtil.copyFile(src, dest, overwrite, preserveFileDate);
            return 1;
        }
        return FileUtil.copyDirectory(src, dest, false, overwrite, preserveFileDate);
    }

    public static void copyFile(File src, File dest, boolean overwrite, boolean preserveFileDate) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src + " does not exist!");
        }
        if (!overwrite && dest.exists()) {
            throw new IOException(dest + " does exist!");
        }
        FileInputStream input = new FileInputStream(src);
        try {
            FileOutputStream output = new FileOutputStream(dest);
            try {
                StreamUtil.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
        if (src.length() != dest.length()) {
            throw new IOException("Failed to copy full contents from '" + src + "' to '" + dest + "'");
        }
        if (preserveFileDate) {
            dest.setLastModified(src.lastModified());
        }
    }

    public static boolean delete(String file) {
        File f = new File(file);
        if (f.exists()) {
            return f.delete();
        }
        return false;
    }

    public static int deleteDirectory(File dir) throws IOException {
        int count = FileUtil.cleanDirectory(dir, true);
        if (!dir.delete()) {
            throw new IOException("Unable to delete directory " + dir);
        }
        return count;
    }

    public static int copyDirectory(File srcDir, File destDir, boolean recursive, boolean overwrite, boolean preserveFileDate) throws IOException {
        if (srcDir == null || destDir == null) {
            throw new NullPointerException("Source or destination directory is null!");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException(srcDir + " does not exist!");
        }
        if (destDir.exists()) {
            if (destDir.isFile()) {
                throw new IOException("Destination " + destDir + " exists but is a file!");
            }
        } else if (!destDir.mkdirs()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created!");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        int count = 0;
        int i = 0;
        while (i < files.length) {
            File copiedFile = new File(destDir, files[i].getName());
            if (files[i].isDirectory() && recursive) {
                count += FileUtil.copyDirectory(files[i], copiedFile, recursive, overwrite, preserveFileDate);
            } else {
                FileUtil.copyFile(files[i], copiedFile, overwrite, preserveFileDate);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int cleanDirectory(File dir, boolean recursive) throws IOException {
        if (!dir.exists()) {
            throw new FileNotFoundException(dir + " does not exist!");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + dir);
        }
        int count = 0;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && recursive) {
                count += FileUtil.cleanDirectory(files[i], true);
            }
            if (files[i].delete()) {
                ++count;
            } else {
                throw new IOException("Unable to delete file " + files[i]);
            }
            ++i;
        }
        return count;
    }

    public static void copyUrlToFile(URL url, File dest) throws IOException {
        InputStream input = url.openStream();
        try {
            OutputStream output = FileUtil.openOutputStream(dest, false);
            try {
                StreamUtil.copy(input, output);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    public static OutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    public static InputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static InputStream openInputStream(String uri) throws CommonsIOException {
        InputStream is = null;
        try {
            URL url = FileUtil.toUrl(uri);
            if (url == null) {
                throw new CommonsIOException(String.valueOf(uri) + " does not found! ");
            }
            is = url.openStream();
        }
        catch (Exception e) {
            throw new CommonsIOException(e.getMessage());
        }
        return is;
    }

    public static void move(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src + " does not exist!");
        }
        if (dest.exists()) {
            if (dest.isFile()) {
                throw new IllegalArgumentException(dest + " does exist and is a file.");
            }
            dest = new File(String.valueOf(dest.getAbsolutePath()) + "/" + src.getName());
        } else {
            dest.mkdirs();
        }
        if (!src.renameTo(dest)) {
            throw new IOException("Fail to move " + src + " to " + dest);
        }
    }

    public static void makeDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtil.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file1, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file2 + "' doesn't exist");
        }
        return FileUtil.isFileNewer(file1, file2.lastModified());
    }

    public static boolean isFileNewer(File file, long time) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file!");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > time;
    }

    public static long size(File file) {
        if (file.isDirectory()) {
            return FileUtil.sizeOfDirectory(file);
        }
        if (file.exists()) {
            return file.length();
        }
        throw new IllegalArgumentException(file + " does not exist!");
    }

    public static long size(File file, String unit) {
        if (unit == null || "".equals(unit)) {
            throw new IllegalArgumentException("No specified unit!");
        }
        long fileSize = FileUtil.size(file);
        if (UNIT_KB.equalsIgnoreCase(unit)) {
            return fileSize / 1024L;
        }
        if (UNIT_MB.equalsIgnoreCase(unit)) {
            return fileSize / 0x100000L;
        }
        if (UNIT_GB.equalsIgnoreCase(unit)) {
            return fileSize / 0x40000000L;
        }
        if (UNIT_TB.equalsIgnoreCase(unit)) {
            return fileSize / 0x10000000000L;
        }
        throw new IllegalArgumentException("Unit argument must be one of 'KB', 'MB', 'GB', or 'TB'!");
    }

    public static long sizeOfDirectory(File dir) {
        if (!dir.exists()) {
            String message = dir + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!dir.isDirectory()) {
            String message = dir + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = dir.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }

    public static double sizeOfDirectory(File dir, String unit) {
        if (unit == null || "".equals(unit)) {
            throw new IllegalArgumentException("No specified unit!");
        }
        long fileSize = FileUtil.sizeOfDirectory(dir);
        if (UNIT_KB.equalsIgnoreCase(unit)) {
            return fileSize / 1024L;
        }
        if (UNIT_MB.equalsIgnoreCase(unit)) {
            return fileSize / 0x100000L;
        }
        if (UNIT_GB.equalsIgnoreCase(unit)) {
            return fileSize / 0x40000000L;
        }
        if (UNIT_TB.equalsIgnoreCase(unit)) {
            return fileSize / 0x10000000000L;
        }
        throw new IllegalArgumentException("Unit argument must be one of 'KB', 'MB', 'GB', or 'TB'!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void swapFilename(File file1, File file2) throws IOException {
        if (!file1.exists()) {
            throw new FileNotFoundException(file1 + " does not exist!");
        }
        if (!file1.exists()) {
            throw new FileNotFoundException(file2 + " does not exist!");
        }
        int idx = 0;
        File tmpFile = null;
        while ((tmpFile = new File(String.valueOf(file1.getAbsolutePath()) + ".tmp" + idx++)).exists()) {
        }
        if (!file1.renameTo(tmpFile)) throw new IOException(file1 + " cannot be renamed to temp file named " + tmpFile);
        if (file2.renameTo(file1)) {
            if (tmpFile.renameTo(file2)) return;
            tmpFile.renameTo(file1);
            file1.renameTo(file2);
            throw new IOException(tmpFile + " cannot be renamed to " + file2);
        }
        tmpFile.renameTo(file1);
        throw new IOException(file2 + " cannot be renmaed to " + file1);
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            OutputStream os = null;
            try {
                try {
                    os = FileUtil.openOutputStream(file, false);
                }
                catch (IOException iOException) {
                    os.close();
                }
            }
            finally {
                os.close();
            }
        } else {
            boolean success = file.setLastModified(System.currentTimeMillis());
            if (!success) {
                throw new IOException("Unable to set the last modification time for " + file);
            }
        }
    }

    public static boolean waitFor(File file, int seconds) {
        int timeout = 0;
        int tick = 0;
        while (!file.exists()) {
            if (tick++ >= 10) {
                tick = 0;
                if (timeout++ > seconds) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                break;
            }
        }
        return true;
    }

    public static boolean exists(String file) {
        File f = new File(file);
        return f.exists();
    }

    public static List list(File path, String pattern, boolean recursive) throws FileNotFoundException {
        FileListFilter filter = null;
        if (pattern != null && !"".equals(pattern)) {
            filter = new FileListFilter(pattern, pattern);
        }
        return FileUtil.list(path, filter, recursive);
    }

    public static List listFileOnly(File path, String pattern, boolean recursive) throws FileNotFoundException {
        FileListFilter filter = null;
        filter = pattern != null ? new FileListFilter(pattern) : new FileListFilter();
        List<File> result = new ArrayList();
        if (recursive) {
            List temp = FileUtil.list(path, filter, recursive);
            int i = 0;
            while (i < temp.size()) {
                File tempFile = (File)temp.get(i);
                if (tempFile.isFile()) {
                    result.add(tempFile);
                }
                ++i;
            }
        } else {
            filter.setOnlyFile(true);
            result = FileUtil.list(path, filter, recursive);
        }
        return result;
    }

    public static List listDirectoryOnly(File path, String pattern, boolean recursive) throws FileNotFoundException {
        FileListFilter filter = null;
        if (pattern != null) {
            filter = new FileListFilter();
            filter.addMatchDirPattern(pattern);
        } else {
            filter = new FileListFilter();
        }
        filter.setOnlyDirectory(true);
        return FileUtil.list(path, filter, recursive);
    }

    public static List list(File path, FileFilter filter, boolean recursive) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path + " does not exist!");
        }
        File[] files = null;
        files = filter != null ? path.listFiles(filter) : path.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                fileList.add(files[i]);
                if (recursive && files[i].isDirectory()) {
                    fileList.addAll(FileUtil.list(files[i], filter, true));
                }
                ++i;
            }
        }
        return fileList;
    }

    public static long freeSpace(String path, String unit) throws IOException {
        long kbSize = FileSystemUtil.freeSpaceKb(path);
        if (UNIT_KB.equalsIgnoreCase(unit)) {
            return kbSize;
        }
        if (UNIT_MB.equalsIgnoreCase(unit)) {
            return kbSize / 1024L;
        }
        if (UNIT_GB.equalsIgnoreCase(unit)) {
            return kbSize / 0x100000L;
        }
        if (UNIT_TB.equalsIgnoreCase(unit)) {
            return kbSize / 0x40000000L;
        }
        throw new IllegalArgumentException("Unit argument must be one of 'KB', 'MB', 'GB', or 'TB'!");
    }

    public static byte[] read(File srcFile) throws IOException {
        InputStream in = null;
        try {
            in = FileUtil.openInputStream(srcFile);
            byte[] byArray = StreamUtil.toByteArray(in);
            return byArray;
        }
        finally {
            StreamUtil.close(in);
        }
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        InputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            String string = StreamUtil.toString(in, encoding);
            return string;
        }
        finally {
            StreamUtil.close(in);
        }
    }

    public static List readLines(File file, String encoding) throws IOException {
        InputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            List list = StreamUtil.readLines(in, encoding);
            return list;
        }
        finally {
            StreamUtil.close(in);
        }
    }

    public static void write(File file, byte[] data) throws IOException {
        FileUtil.write(file, data, false);
    }

    public static void write(File file, byte[] data, boolean append) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, append);
            out.write(data);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static void writeLines(File file, Collection data) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, false);
            StreamUtil.writeLines(data, out);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static void writeLines(File file, Collection data, String encoding) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, false);
            StreamUtil.writeLines(data, out, encoding);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static void writeLines(File file, Collection data, String encoding, String lineEnding) throws IOException {
        OutputStream out = null;
        try {
            out = FileUtil.openOutputStream(file, false);
            StreamUtil.writeLines(data, out, encoding, lineEnding);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = String.valueOf(filename.substring(0, pos)) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public static URL toUrl(String file) {
        URL url;
        block13: {
            if (file == null) {
                return null;
            }
            url = null;
            try {
                File f;
                String resourceName;
                if (file.startsWith("http://") || file.startsWith("file:/")) {
                    url = new URL(file);
                    break block13;
                }
                if ((file.startsWith("/") || file.startsWith("\\")) && (url = FileUtil.toUrl(resourceName = file.substring(1))) != null) {
                    return url;
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    url = cl.getResource(file);
                }
                if (url == null) {
                    url = Thread.currentThread().getClass().getResource(file);
                }
                if (url == null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    url = clazz.getResource(file);
                }
                if (url == null) {
                    url = ClassLoader.getSystemResource(file);
                }
                if (url == null && (f = new File(file)).exists()) {
                    url = f.toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(".");
        int lastSeparator = FileUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getBaseName(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtil.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        int sep = FileUtil.indexOfLastSeparator(filename);
        if (sep != -1) {
            return filename.substring(sep, index);
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtil.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String getFilename(String file) {
        if (file == null) {
            return null;
        }
        int index = FileUtil.indexOfLastSeparator(file);
        return file.substring(index + 1);
    }

    public static String getPath(String filename, boolean withEndSeparator) {
        if (filename == null) {
            return null;
        }
        int prefix = FileUtil.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        int index = FileUtil.indexOfLastSeparator(filename);
        if (prefix >= filename.length() || index < 0) {
            return "";
        }
        int separatorAdd = withEndSeparator ? 1 : 0;
        return filename.substring(prefix, index + separatorAdd);
    }

    public static String getAbsolutePath(String file, boolean withEndSeparator) {
        String path = null;
        File f = new File(file);
        if (f.exists()) {
            if (f.isDirectory()) {
                path = f.getAbsolutePath();
            } else {
                File parent = f.getParentFile();
                if (parent != null) {
                    path = parent.getAbsolutePath();
                }
            }
            if (path != null && withEndSeparator && !FileUtil.isSeparator(path.charAt(path.length() - 1))) {
                path = String.valueOf(path) + SYSTEM_SEPARATOR;
            }
        }
        return path;
    }

    public static boolean isExtension(String file, String[] extension) {
        if (file == null) {
            return false;
        }
        if (extension == null || extension.length == 0) {
            return FileUtil.indexOfExtension(file) == -1;
        }
        String fileExt = FileUtil.getExtension(file);
        int i = 0;
        while (i < extension.length) {
            if (fileExt.equals(extension[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean wildcardMatch(String filename, String pattern, boolean caseSensitivity) {
        if (filename == null && pattern == null) {
            return true;
        }
        if (filename == null || pattern == null) {
            return false;
        }
        if (caseSensitivity) {
            filename = filename.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        String[] wcs = FileUtil.splitOnTokens(pattern);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    ++textIdx;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = filename.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = filename.indexOf(wcs[wcsIdx], textIdx)) == -1) break;
                        int repeat = filename.indexOf(wcs[wcsIdx], textIdx + 1);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!filename.startsWith(wcs[wcsIdx], textIdx)) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != filename.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    public static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    private static int getPrefixLength(String filename) {
        if (filename == null) {
            return -1;
        }
        int len = filename.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FileUtil.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename.indexOf(47, 1);
            int posWin = filename.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FileUtil.isSeparator(filename.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FileUtil.isSeparator(ch0) && FileUtil.isSeparator(ch1)) {
            int posUnix = filename.indexOf(47, 2);
            int posWin = filename.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return FileUtil.isSeparator(ch0) ? 1 : 0;
    }

    public static String normalizeFilename(String filename, boolean keepSeparator) {
        if (filename == null) {
            return null;
        }
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = FileUtil.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        int i = 0;
        while (i < array.length) {
            if (array[i] == OTHER_SEPARATOR) {
                array[i] = SYSTEM_SEPARATOR;
            }
            ++i;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != SYSTEM_SEPARATOR) {
            array[size++] = SYSTEM_SEPARATOR;
            lastIsDirectory = false;
        }
        int i2 = prefix + 1;
        while (i2 < size) {
            if (array[i2] == SYSTEM_SEPARATOR && array[i2 - 1] == SYSTEM_SEPARATOR) {
                System.arraycopy(array, i2, array, i2 - 1, size - i2);
                --size;
                --i2;
            }
            ++i2;
        }
        i2 = prefix + 1;
        while (i2 < size) {
            if (array[i2] == SYSTEM_SEPARATOR && array[i2 - 1] == '.' && (i2 == prefix + 1 || array[i2 - 2] == SYSTEM_SEPARATOR)) {
                if (i2 == size - 1) {
                    lastIsDirectory = true;
                }
                System.arraycopy(array, i2 + 1, array, i2 - 1, size - i2);
                size -= 2;
                --i2;
            }
            ++i2;
        }
        i2 = prefix + 2;
        while (i2 < size) {
            block20: {
                if (array[i2] == SYSTEM_SEPARATOR && array[i2 - 1] == '.' && array[i2 - 2] == '.' && (i2 == prefix + 2 || array[i2 - 3] == SYSTEM_SEPARATOR)) {
                    if (i2 == prefix + 2) {
                        return null;
                    }
                    if (i2 == size - 1) {
                        lastIsDirectory = true;
                    }
                    int j = i2 - 4;
                    while (j >= prefix) {
                        if (array[j] == SYSTEM_SEPARATOR) {
                            System.arraycopy(array, i2 + 1, array, j + 1, size - i2);
                            size -= i2 - j;
                            i2 = j + 1;
                            break block20;
                        }
                        --j;
                    }
                    System.arraycopy(array, i2 + 1, array, prefix, size - i2);
                    size -= i2 + 1 - prefix;
                    i2 = prefix + 1;
                }
            }
            ++i2;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    public static String concat(String path, String filename) {
        int prefix = FileUtil.getPrefixLength(filename);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return FileUtil.normalizeFilename(filename, true);
        }
        if (path == null) {
            return null;
        }
        int len = path.length();
        if (len == 0) {
            return FileUtil.normalizeFilename(filename, true);
        }
        char ch = path.charAt(len - 1);
        if (FileUtil.isSeparator(ch)) {
            return FileUtil.normalizeFilename(String.valueOf(path) + filename, true);
        }
        return FileUtil.normalizeFilename(String.valueOf(path) + '/' + filename, true);
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf("?") == -1 && text.indexOf("*") == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            if (array[i] == '?' || array[i] == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i] == '?') {
                    list.add("?");
                } else if (list.size() == 0 || i > 0 && !list.get(list.size() - 1).equals("*")) {
                    list.add("*");
                }
            } else {
                buffer.append(array[i]);
            }
            ++i;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

