/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.io;

import com.tradevan.commons.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FileListFilter
implements FileFilter,
FilenameFilter,
Serializable {
    private static final long serialVersionUID = 57136625871976836L;
    public static final String AGGREGATION_AND = "AND";
    public static final String AGGREGATION_OR = "OR";
    private String aggregation = "AND";
    private List patterns = null;
    private List dirPatterns = null;
    private List filters = null;
    private boolean onlyCanRead = false;
    private boolean onlyCanWrite = false;
    private boolean onlyDirectory = false;
    private boolean onlyEmptyFile = false;
    private boolean onlyFile = false;
    private boolean hiddenFile = false;
    private boolean visibleFile = false;
    private long sizeBigger = -1L;
    private long sizeSmaller = -1L;

    public FileListFilter() {
    }

    public FileListFilter(String pattern) {
        this.patterns = new ArrayList();
        this.dirPatterns = new ArrayList();
        this.patterns.add(pattern);
    }

    public FileListFilter(String pattern, String dirPattern) {
        this.patterns = new ArrayList();
        this.dirPatterns = new ArrayList();
        this.patterns.add(pattern);
        this.dirPatterns.add(dirPattern);
    }

    public boolean accept(File file) {
        int i;
        if (file == null) {
            return false;
        }
        boolean isMatchOne = AGGREGATION_OR.equals(this.aggregation);
        if (isMatchOne) {
            int i2;
            if (this.patterns != null && !file.isDirectory()) {
                i2 = 0;
                while (i2 < this.patterns.size()) {
                    if (FileUtil.wildcardMatch(file.getName(), (String)this.patterns.get(i2), false)) {
                        return true;
                    }
                    ++i2;
                }
            } else if (this.dirPatterns != null && file.isDirectory()) {
                i2 = 0;
                while (i2 < this.dirPatterns.size()) {
                    if (FileUtil.wildcardMatch(file.getName(), (String)this.dirPatterns.get(i2), false)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (this.filters != null) {
                i2 = 0;
                while (i2 < this.filters.size()) {
                    if (((FileFilter)this.filters.get(i2)).accept(file)) {
                        return true;
                    }
                    ++i2;
                }
            }
            boolean result = !this.onlyCanRead || file.canRead() || !this.onlyCanWrite || file.canWrite() || !this.onlyDirectory || file.isDirectory() || !this.onlyEmptyFile || file.length() == 0L || !this.onlyFile || !file.isFile() || !this.hiddenFile || file.isHidden() || !this.visibleFile || !file.isHidden() || this.sizeBigger < 0L || file.length() < this.sizeBigger || this.sizeSmaller < 0L || file.length() > this.sizeSmaller;
            return result;
        }
        if (this.patterns != null && !file.isDirectory()) {
            i = 0;
            while (i < this.patterns.size()) {
                if (!FileUtil.wildcardMatch(file.getName(), (String)this.patterns.get(i), false)) {
                    return false;
                }
                ++i;
            }
        } else if (this.dirPatterns != null && file.isDirectory()) {
            i = 0;
            while (i < this.dirPatterns.size()) {
                if (!FileUtil.wildcardMatch(file.getName(), (String)this.dirPatterns.get(i), false)) {
                    return false;
                }
                ++i;
            }
        }
        if (this.filters != null) {
            i = 0;
            while (i < this.filters.size()) {
                if (!((FileFilter)this.filters.get(i)).accept(file)) {
                    return false;
                }
                ++i;
            }
        }
        boolean result = !(this.onlyCanRead && !file.canRead() || this.onlyCanWrite && !file.canWrite() || this.onlyDirectory && !file.isDirectory() || this.onlyEmptyFile && file.length() != 0L || this.onlyFile && !file.isFile() || this.hiddenFile && !file.isHidden() || this.visibleFile && file.isHidden() || this.sizeBigger >= 0L && file.length() >= this.sizeBigger || this.sizeSmaller >= 0L && file.length() <= this.sizeSmaller);
        return result;
    }

    public boolean accept(File dir, String filename) {
        if (dir == null || filename == null) {
            return false;
        }
        return this.accept(new File(String.valueOf(dir.getAbsolutePath()) + "/" + filename));
    }

    public void setOnlyCanRead(boolean canRead) {
        this.onlyCanRead = canRead;
    }

    public boolean onlyCanRead() {
        return this.onlyCanRead;
    }

    public void setOnlyCanWrite(boolean canWrite) {
        this.onlyCanWrite = canWrite;
    }

    public boolean onlyCanWrite() {
        return this.onlyCanWrite;
    }

    public void setOnlyDirectory(boolean onlyDir) {
        this.onlyDirectory = onlyDir;
    }

    public boolean onlyDirectory() {
        return this.onlyDirectory;
    }

    public void setOnlyEmptyFile(boolean emptyFile) {
        this.onlyEmptyFile = emptyFile;
    }

    public boolean onlyEmptyFile() {
        return this.onlyEmptyFile;
    }

    public void setOnlyFile(boolean onlyFile) {
        this.onlyFile = onlyFile;
    }

    public boolean onlyFile() {
        return this.onlyFile;
    }

    public void setVisibility(boolean hidden, boolean visible) {
        this.hiddenFile = hidden;
        this.visibleFile = visible;
    }

    public boolean acceptHiddenFile() {
        return this.hiddenFile;
    }

    public boolean acceptVisibleFile() {
        return this.visibleFile;
    }

    public void setSizeBigger(long size) {
        this.sizeBigger = size;
    }

    public long getSizeBigger() {
        return this.sizeBigger;
    }

    public void setSizeSmaller(long size) {
        this.sizeSmaller = size;
    }

    public long getSizeSmaller() {
        return this.sizeSmaller;
    }

    public void addMatchDirPattern(String pattern) {
        if (this.dirPatterns == null) {
            this.dirPatterns = new ArrayList();
        }
        this.dirPatterns.add(pattern);
    }

    public void addMatchDirPattern(String[] pattern) {
        if (this.dirPatterns == null) {
            this.dirPatterns = new ArrayList();
        }
        if (pattern != null && pattern.length > 0) {
            int i = 0;
            while (i < pattern.length) {
                this.dirPatterns.add(pattern[i]);
                ++i;
            }
        }
    }

    public String[] getMatchDirPattern() {
        String[] result = new String[this.dirPatterns.size()];
        this.dirPatterns.toArray(result);
        return result;
    }

    public String getMatchDirPattern(int index) {
        return (String)this.dirPatterns.get(index);
    }

    public boolean removeMatchDirPattern(String old) {
        return this.dirPatterns.remove(old);
    }

    public void addMatchPattern(String pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList();
        }
        this.patterns.add(pattern);
    }

    public void addMatchPattern(String[] pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList();
        }
        if (pattern != null && pattern.length > 0) {
            int i = 0;
            while (i < pattern.length) {
                this.patterns.add(pattern[i]);
                ++i;
            }
        }
    }

    public String[] getMatchPattern() {
        String[] result = new String[this.patterns.size()];
        this.patterns.toArray(result);
        return result;
    }

    public String getMatchPattern(int index) {
        return (String)this.patterns.get(index);
    }

    public boolean removeMatchPattern(String old) {
        return this.patterns.remove(old);
    }

    public void setAggregation(String logic) {
        if (AGGREGATION_AND.equalsIgnoreCase(logic)) {
            this.aggregation = AGGREGATION_AND;
        } else if (AGGREGATION_OR.equals(logic)) {
            this.aggregation = AGGREGATION_OR;
        } else {
            throw new IllegalArgumentException("Aggregation must be one of 'AND' or 'OR' operation.");
        }
    }

    public void addFileFilter(FileFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        if (filter != null) {
            this.filters.add(filter);
        }
    }
}

