/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.id;

import com.tradevan.commons.id.UUID;
import com.tradevan.commons.lang.StringUtil;

public class UuidGenerator {
    public static final int RANDOM_UUID = 4;
    private static final int TIME_BASED_UUID = 1;
    private static final int DEFAULT_UUID = 1;

    public static String nextId() {
        return UuidGenerator.nextId(1, false, false);
    }

    public static String nextId(boolean format) {
        return UuidGenerator.nextId(1, format, false);
    }

    public static String nextId(boolean format, boolean prefix) {
        return UuidGenerator.nextId(1, format, prefix);
    }

    private static String nextId(int version) {
        return UuidGenerator.nextId(version, true, false);
    }

    private static String nextId(int version, boolean format) {
        return UuidGenerator.nextId(version, format, false);
    }

    private static synchronized String nextId(int version, boolean format, boolean prefix) {
        UUID uuid = null;
        switch (version) {
            case 4: {
                uuid = UUID.randomUUID();
            }
        }
        if (uuid != null) {
            String uuidStr = uuid.toString();
            if (!format) {
                uuidStr = StringUtil.removeChar(uuidStr, "-");
            }
            if (prefix) {
                uuidStr = "urn:uuid:" + uuidStr;
            }
            return uuidStr;
        }
        throw new RuntimeException("");
    }
}

