/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.id;

import com.tradevan.commons.id.BaseId;
import java.util.Random;

public class SessionId
extends BaseId {
    private static final long serialVersionUID = 3328303457695552367L;
    private static final int DEFAULT_ALPHANUMERIC_IDENTIFIER_SIZE = 15;
    private static final int ALPHA_NUMERIC_CHARSET_SIZE = 36;
    private static final long MAX_RANDOM_LEN = 2176782336L;
    private static final long MAX_TIME_SECTION_LEN = 46656L;
    private static final long TIC_DIFFERENCE = 2000L;
    private int counter = 0;
    private long lastTimeValue = 0L;
    private static Random randomizer = new Random();

    public synchronized String nextId() {
        if (this.prefix != null || this.suffix != null) {
            StringBuffer sb = new StringBuffer();
            if (this.prefix != null) {
                sb.append(this.getPrefixString());
            }
            sb.append(this.nextStringIdentifier());
            if (this.suffix != null) {
                sb.append(this.getSuffixString());
            }
            return sb.toString();
        }
        return this.nextStringIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextStringIdentifier() {
        long currentRandom = randomizer.nextLong();
        if (currentRandom < 0L) {
            currentRandom = -currentRandom;
        }
        currentRandom %= 2176782336L;
        currentRandom += 2176782336L;
        long currentTimeValue = 0L;
        int currentCount = 0;
        SessionId sessionId = this;
        synchronized (sessionId) {
            currentTimeValue = System.currentTimeMillis() / 2000L;
            currentTimeValue %= 46656L;
            if (this.lastTimeValue != (currentTimeValue += 46656L)) {
                this.lastTimeValue = currentTimeValue;
                this.counter = 0;
            }
            currentCount = this.counter++;
        }
        StringBuffer id = new StringBuffer(15);
        id.append(Long.toString(currentRandom, 36).substring(1));
        id.append(Long.toString(currentTimeValue, 36).substring(1));
        id.append(Long.toString(currentCount, 36));
        return id.toString();
    }
}

