/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.id;

import com.tradevan.commons.id.BaseId;
import com.tradevan.commons.lang.StringUtil;

public class NumberBaseId
extends BaseId {
    private static final long serialVersionUID = -7461643833624987643L;
    private boolean concatSuffix = true;
    private boolean rolling = true;
    private int length = 5;
    private long maxValue = 99999L;
    private long minValue = 0L;
    private long currentValue = 0L;
    private int radix;
    private String currentId = null;
    private String idFormat = "00000";
    private String padding = "0";

    public NumberBaseId() {
        this.radix = 10;
    }

    public NumberBaseId(int radix) {
        this.radix = radix;
    }

    public synchronized String increase() {
        ++this.currentValue;
        if (this.currentValue > this.maxValue && this.rolling) {
            if (this.rolling) {
                this.reset();
            } else {
                throw new RuntimeException("current value " + this.currentValue + " is over maxValue " + this.maxValue);
            }
        }
        this.currentId = this.getFormattedId();
        return this.currentId;
    }

    public boolean hasNextId() {
        return this.currentValue + 1L <= this.maxValue;
    }

    public void reset() {
        this.currentValue = this.minValue;
    }

    public String getCurrentId() {
        if (this.currentId == null) {
            this.currentId = this.getFormattedId();
        }
        return this.currentId;
    }

    public void setMaxValue(String n) {
        if (StringUtil.isEmpty(n)) {
            throw new RuntimeException(String.valueOf(n) + " is not a valid value!");
        }
        try {
            this.maxValue = Long.parseLong(n, this.radix);
            this.length = n.length();
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(n) + " is not a valid value!");
        }
    }

    public String getMaxStrValue() {
        return Long.toString(this.maxValue, this.radix);
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        String tmp = Long.toString(maxValue, this.radix);
        this.length = tmp.length();
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(String n) {
        if (StringUtil.isEmpty(n)) {
            throw new RuntimeException(String.valueOf(n) + " is not a valid value!");
        }
        try {
            this.minValue = Long.parseLong(n, this.radix);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(n) + " is not a valid value!");
        }
    }

    public String getMinStrValue() {
        return Long.toString(this.minValue, this.radix);
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setLength(int length) {
        if (length > 0) {
            this.length = length;
            if (this.padding != null) {
                this.idFormat = StringUtil.repeatStr(this.padding, length);
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getRadix() {
        return this.radix;
    }

    public synchronized String nextId() {
        if (this.prefix == null && this.suffix == null) {
            return this.increase();
        }
        StringBuffer sb = new StringBuffer();
        if (this.prefix != null) {
            sb.append(this.getPrefixString());
        }
        if (this.suffix != null) {
            if (this.suffix instanceof NumberBaseId) {
                NumberBaseId numBaseId = (NumberBaseId)this.suffix;
                if (this.concatSuffix) {
                    if (!numBaseId.hasNextId()) {
                        numBaseId.reset();
                        this.increase();
                    }
                } else {
                    this.increase();
                }
                sb.append(this.getCurrentId());
                sb.append(numBaseId.nextId());
            } else {
                sb.append(this.increase());
                sb.append(this.getSuffixString());
            }
        } else {
            sb.append(this.increase());
        }
        return sb.toString();
    }

    public void setConcatSuffix(boolean concatSuffix) {
        this.concatSuffix = concatSuffix;
    }

    public boolean isConcatSuffix() {
        return this.concatSuffix;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public String getPadding() {
        return this.padding;
    }

    private String getFormattedId() {
        String formattedId = Long.toString(this.currentValue, this.radix);
        int idLen = formattedId.length();
        if (idLen < this.length && this.padding != null) {
            formattedId = String.valueOf(this.idFormat.substring(0, this.length - idLen)) + formattedId;
        }
        if (idLen > this.length) {
            formattedId = formattedId.substring(this.length - idLen);
        }
        return formattedId;
    }
}

