/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.format;

import com.tradevan.commons.lang.StringUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TextFormatUtil {
    public static String format(String str, List arguments) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        if (arguments == null || arguments.isEmpty()) {
            return str;
        }
        return MessageFormat.format(str, arguments.toArray());
    }

    public static String format(String str, Map arguments) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        if (arguments == null || arguments.isEmpty()) {
            return str;
        }
        HashMap<String, String> indexMap = new HashMap<String, String>();
        Object[] args = new Object[arguments.size()];
        int index = 0;
        Iterator it = arguments.keySet().iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            args[index] = arguments.get(k);
            indexMap.put(k, "{" + Integer.toString(index) + "}");
            ++index;
        }
        str = StringUtil.replaceVariable(str, indexMap);
        return MessageFormat.format(str, args);
    }

    public static String[] format(String str, Object[][] arguments) {
        if (StringUtil.isEmpty(str) && arguments != null) {
            return new String[arguments.length];
        }
        if (arguments == null) {
            return null;
        }
        String[] result = new String[arguments.length];
        int i = 0;
        while (i < result.length) {
            result[i] = arguments[i] != null && arguments[i].length > 0 ? MessageFormat.format(str, arguments[i]) : str;
            ++i;
        }
        return result;
    }

    public static String[] format(String str, Map[] arguments) {
        if (StringUtil.isEmpty(str) && arguments != null) {
            return new String[arguments.length];
        }
        if (arguments == null) {
            return null;
        }
        String[] result = new String[arguments.length];
        int i = 0;
        while (i < result.length) {
            result[i] = TextFormatUtil.format(str, arguments[i]);
            ++i;
        }
        return result;
    }
}

