/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.format;

import com.tradevan.commons.lang.StringUtil;
import java.text.DecimalFormat;

public class NumberFormatUtil {
    private static final char HOLOMORPHIC_MINUS = '\uff0d';
    private static final char CHINESE_MINUS = '\u8ca0';
    private static final char[] HOLOMORPHIC_NUM = new char[]{'\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19'};
    private static final char[] CHINESE_LOWER_NUM = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final char[] CHINESE_UPPER_NUM = new char[]{'\u96f6', '\u58f9', '\u8cb3', '\u53c3', '\u8086', '\u4f0d', '\u9678', '\u67d2', '\u634c', '\u7396'};
    private static final String[] PRICE_UNIT_LOWER = new String[]{"", "\u5341", "\u767e", "\u5343", "\u842c", "\u5341", "\u767e", "\u5343", "\u5104", "\u5341", "\u767e", "\u5343", "\u842c", "\u5146", "\u5341", "\u767e", "\u5343", "\u842c", "\u5104", "\u5146\u5146"};
    private static final String[] PRICE_UNIT_UPPER = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u842c", "\u62fe", "\u4f70", "\u4edf", "\u5104", "\u62fe", "\u4f70", "\u4edf", "\u842c", "\u5146", "\u62fe", "\u4f70", "\u4edf", "\u842c", "\u5104", "\u5146\u5146"};

    /*
     * Unable to fully structure code
     */
    public static String toChineseNumber(long num, boolean hasCarry, boolean capital) {
        block9: {
            block8: {
                numStr = Long.toString(Math.abs(num));
                chineseNum = null;
                priceUnit = null;
                if (capital) {
                    chineseNum = NumberFormatUtil.CHINESE_UPPER_NUM;
                    priceUnit = NumberFormatUtil.PRICE_UNIT_UPPER;
                } else {
                    chineseNum = NumberFormatUtil.CHINESE_LOWER_NUM;
                    priceUnit = NumberFormatUtil.PRICE_UNIT_LOWER;
                }
                sb = new StringBuffer(numStr.length() * 2);
                if (hasCarry) break block8;
                numChar = numStr.toCharArray();
                i = 0;
                while (i < numChar.length) {
                    sb.append(chineseNum[numChar[i] - 48]);
                    ++i;
                }
                break block9;
            }
            if (numStr.length() > priceUnit.length) {
                throw new RuntimeException("Out of price unit!");
            }
            numChar = numStr.toCharArray();
            numLen = numChar.length;
            idx = 0;
            i = 0;
            while (i < numLen) {
                block10: {
                    idx = numLen - i - 1;
                    if (numChar[idx] == '0') ** GOTO lbl37
                    sb.insert(0, priceUnit[i]);
                    sb.insert(0, chineseNum[numChar[idx] - 48]);
                    break block10;
                    while (numChar[idx = numLen - i - 2] == '0') {
                        ++i;
lbl37:
                        // 2 sources

                        if (i + 1 < numLen) continue;
                    }
                    if (sb.length() > 0 || num == 0L) {
                        sb.insert(0, chineseNum[0]);
                    }
                }
                ++i;
            }
        }
        if (num < 0L) {
            sb.insert(0, '\u8ca0');
        }
        return sb.toString();
    }

    public static String toHolomorphicNum(long num) {
        String numStr = Long.toString(Math.abs(num));
        StringBuffer sb = new StringBuffer(numStr.length());
        char[] numChar = numStr.toCharArray();
        int i = 0;
        while (i < numChar.length) {
            sb.append(HOLOMORPHIC_NUM[numChar[i] - 48]);
            ++i;
        }
        if (num < 0L) {
            sb.insert(0, '\uff0d');
        }
        return sb.toString();
    }

    public static long parseHolomorphicNum(String num) {
        if (StringUtil.isEmpty(num)) {
            throw new IllegalArgumentException("The number can't be empty!");
        }
        StringBuffer sb = new StringBuffer(num.length());
        char[] numChar = num.toCharArray();
        int start = 0;
        if (numChar[0] == '\uff0d' || numChar[0] == '-') {
            sb.append("-");
            ++start;
        }
        int i = start;
        while (i < numChar.length) {
            if (numChar[i] >= '0' && numChar[i] <= '9') {
                sb.append(numChar[i]);
            } else {
                int n = numChar[i] - HOLOMORPHIC_NUM[0];
                if (n < 0 || n > 9) {
                    throw new IllegalArgumentException("The number " + num + " is invalid");
                }
                sb.append((char)(48 + n));
            }
            ++i;
        }
        return Long.parseLong(sb.toString());
    }

    public static String formatByComma(long num) {
        String numStr = Long.toString(num);
        char[] numChar = numStr.toCharArray();
        int len = numChar.length;
        StringBuffer sb = new StringBuffer(len);
        int start = 0;
        if (num < 0L) {
            sb.append('-');
            start = 1;
        }
        --len;
        int i = start;
        while (i <= len) {
            sb.append(numChar[i]);
            if (i < len && (len - i) % 3 == 0) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatByComma(double num) {
        int pos;
        String numStr = Double.toString(num);
        char[] numChar = numStr.toCharArray();
        int len = numChar.length;
        StringBuffer sb = new StringBuffer(len);
        int start = 0;
        if (num < 0.0) {
            sb.append('-');
            start = 1;
        }
        pos = (pos = numStr.indexOf(".")) < 0 ? len - 1 : --pos;
        while (start <= pos) {
            sb.append(numChar[start]);
            if (start < pos && (pos - start) % 3 == 0) {
                sb.append(",");
            }
            ++start;
        }
        while (start < len) {
            sb.append(numChar[start]);
            ++start;
        }
        return sb.toString();
    }

    public static String format(long num, String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(num);
    }

    public static String format(long num, int length) {
        if (length < 1) {
            return "";
        }
        String pattern = StringUtil.repeatStr("0", length);
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(num);
    }

    public static String format(double num, String pattern) {
        if (StringUtil.isEmpty(pattern)) {
            return "";
        }
        DecimalFormat formatter = new DecimalFormat(pattern);
        return formatter.format(num);
    }
}

