/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.format;

import com.tradevan.commons.format.NumberFormatUtil;
import com.tradevan.commons.lang.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateFormatUtil {
    private static Map formatMap = new HashMap(10);
    private static int POOL_SIZE = 10;

    public static String format(Date date, String format) {
        if (date == null || StringUtil.isEmpty(format)) {
            return "";
        }
        return DateFormatUtil.getFormatter(format).format(date);
    }

    public static String format(Calendar calendar, String format) {
        if (calendar == null || StringUtil.isEmpty(format)) {
            return "";
        }
        return DateFormatUtil.getFormatter(format).format(calendar.getTime());
    }

    public static String format(long time, String format) {
        if (StringUtil.isEmpty(format)) {
            return "";
        }
        return DateFormatUtil.getFormatter(format).format(new Date(time));
    }

    public static Date toDate(String dateString, String format) {
        if (StringUtil.isEmpty(dateString) && StringUtil.isEmpty(format)) {
            return null;
        }
        try {
            return DateFormatUtil.getFormatter(format).parse(dateString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Calendar toCalendar(String dateString, String format) {
        if (StringUtil.isEmpty(dateString) && StringUtil.isEmpty(format)) {
            return null;
        }
        try {
            SimpleDateFormat formatter = DateFormatUtil.getFormatter(format);
            Date date = formatter.parse(dateString);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toChineseDate(Date date, String format) {
        if (date == null || StringUtil.isEmpty(format)) {
            return "";
        }
        String[] yearPattern = StringUtil.splitByPattern(format, "Yy");
        if (yearPattern.length > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1) - 1911;
            String yearStr = Integer.toString(year);
            int yearLength = yearStr.length();
            if (year < 0) {
                --yearLength;
            }
            HashMap<String, String> yearMap = new HashMap<String, String>();
            int i = 0;
            while (i < yearPattern.length) {
                if (yearPattern[i].length() < yearLength) {
                    yearMap.put(yearPattern[i], yearStr);
                } else {
                    yearMap.put(yearPattern[i], NumberFormatUtil.format((long)year, yearPattern[i].length()));
                }
                ++i;
            }
            format = StringUtil.replace(format, yearMap);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDateFormat getFormatter(String format) {
        SimpleDateFormat sdf = (SimpleDateFormat)formatMap.get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
            Map map = formatMap;
            synchronized (map) {
                if (formatMap.size() > POOL_SIZE) {
                    formatMap.clear();
                }
                formatMap.put(format, sdf);
            }
        }
        if (formatMap.size() > POOL_SIZE) {
            Map map = formatMap;
            synchronized (map) {
                formatMap.clear();
                formatMap.put(format, sdf);
            }
        }
        return sdf;
    }
}

