/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.collection;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.collection.CollectionUtil;
import com.tradevan.commons.util.Filter;
import com.tradevan.commons.util.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class MapUtil {
    public static void addMultiValue(Map map, Object key, Collection values) {
        if (map != null && key != null && values != null) {
            ArrayList collection = (ArrayList)map.get(key);
            if (collection == null) {
                collection = new ArrayList();
                map.put(key, collection);
            }
            collection.addAll(values);
        }
    }

    public static void addMultiValue(Map map, Object key, Object[] values) {
        if (map != null && key != null && values != null) {
            ArrayList collection = (ArrayList)map.get(key);
            if (collection == null) {
                collection = new ArrayList();
                map.put(key, collection);
            }
            CollectionUtil.addAll((Collection)collection, values);
        }
    }

    public static boolean containsAllKey(Map map, Object[] key) {
        if (map == null) {
            return false;
        }
        if (key == null) {
            return true;
        }
        if (map.size() >= key.length) {
            int i = 0;
            while (i < key.length) {
                if (!map.containsKey(key[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean containsAllValue(Map map, Object[] value) {
        if (map == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        if (map.size() >= value.length) {
            int i = 0;
            while (i < value.length) {
                if (!map.containsValue(value[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean containsAnyKey(Map map, Object[] key) {
        if (map == null) {
            return false;
        }
        if (key == null) {
            return true;
        }
        int i = 0;
        while (i < key.length) {
            if (map.containsKey(key[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsAnyValue(Map map, Object[] value) {
        if (map == null) {
            return false;
        }
        if (value == null) {
            return true;
        }
        int i = 0;
        while (i < value.length) {
            if (map.containsValue(value[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Map filter(Map map, Filter keyFilter, Filter valueFilter) {
        return MapUtil.filter(map, keyFilter, valueFilter, new HashMap());
    }

    public static Map filter(Map map, Filter keyFilter, Filter valueFilter, Map newMap) {
        if (map == null) {
            return newMap;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            boolean acceptKey = true;
            boolean acceptValue = true;
            if (keyFilter != null) {
                acceptKey = keyFilter.accept(key);
            }
            if (valueFilter != null) {
                acceptValue = valueFilter.accept(value);
            }
            if (!acceptKey || !acceptValue) continue;
            newMap.put(key, value);
        }
        return newMap;
    }

    public static Object get(Map map, Object key, Object defaultValue) {
        if (map == null || key == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null && defaultValue != null) {
            map.put(key, defaultValue);
            value = defaultValue;
        }
        return value;
    }

    public static List getMultiValue(Map map, Object key) {
        if (map != null && key != null) {
            return (List)map.get(key);
        }
        return null;
    }

    public static Object[] mapKeys(Map map) {
        if (map == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return map.keySet().toArray();
    }

    public static Object[] mapValues(Map map) {
        if (map == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return map.values().toArray();
    }

    public static void putMultiValue(Map map, Object key, Collection values) {
        if (map != null && key != null && values != null) {
            ArrayList list = new ArrayList();
            list.addAll(values);
            map.put(key, list);
        }
    }

    public static void putMultiValue(Map map, Object key, Object[] values) {
        if (map != null && key != null && values != null) {
            List list = CollectionUtil.toList(values);
            map.put(key, list);
        }
    }

    public static Map toMap(ResourceBundle resourceBundle) {
        return MapUtil.toMap(resourceBundle, new HashMap());
    }

    public static Map toMap(ResourceBundle resourceBundle, Map map) {
        if (resourceBundle == null) {
            return null;
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = resourceBundle.getObject(key);
            map.put(key, value);
        }
        return map;
    }

    public static Properties toProperties(Map map) {
        Properties answer = new Properties();
        if (map != null) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                answer.put(key, value);
            }
        }
        return answer;
    }

    public static Map transform(Map map, Transformer keyTransformer, Transformer valueTransformer) {
        return MapUtil.transform(map, keyTransformer, valueTransformer, new HashMap());
    }

    public static Map transform(Map map, Transformer keyTransformer, Transformer valueTransformer, Map newMap) {
        if (map == null) {
            return newMap;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (keyTransformer != null) {
                key = keyTransformer.transform(key);
            }
            if (valueTransformer != null) {
                value = valueTransformer.transform(value);
            }
            if (key == null || value == null) continue;
            newMap.put(key, value);
        }
        return newMap;
    }
}

