/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.collection;

import com.tradevan.commons.CommonRuntimeException;
import com.tradevan.commons.lang.ClassUtil;
import com.tradevan.commons.lang.NumberUtil;
import com.tradevan.commons.lang.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DataObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8689507449497662470L;
    protected Map values;
    protected boolean keySensitive = true;

    public DataObject(Map values) {
        if (values == null) {
            throw new CommonRuntimeException("The parameter of DataObject constructor cannot be null!");
        }
        this.values = values;
    }

    public DataObject() {
        this.values = new HashMap();
    }

    public void setValue(String key, Object value) {
        if (key != null) {
            if (this.keySensitive) {
                this.values.put(key, value);
            } else {
                this.values.put(key.toUpperCase(), value);
            }
        }
    }

    public Object getValue(String key) {
        if (key != null) {
            if (this.keySensitive) {
                return this.values.get(key);
            }
            return this.values.get(key.toUpperCase());
        }
        return null;
    }

    public String getString(String key) {
        Object value;
        if (key != null && (value = this.getValue(key)) != null) {
            return value.toString();
        }
        return null;
    }

    public Integer getInteger(String key) {
        String s;
        if (key != null && NumberUtil.isDigits(s = this.getString(key))) {
            return new Integer(s);
        }
        return null;
    }

    public int getInt(String key) {
        int n = 0;
        if (key != null) {
            n = NumberUtil.parseInt(this.getValue(key));
        }
        return n;
    }

    public void setKeySensitive(boolean keySensitive) {
        this.keySensitive = keySensitive;
    }

    public boolean isKeySensitive() {
        return this.keySensitive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keySensitive ? 1231 : 1237);
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataObject)) {
            return false;
        }
        DataObject other = (DataObject)obj;
        if (this.keySensitive != other.keySensitive) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public Map toMap() {
        return this.values;
    }

    public Object[] getValues() {
        return this.values.values().toArray();
    }

    public Object[] getKeys() {
        return this.values.keySet().toArray();
    }

    public void clear() {
        this.values.clear();
    }

    public void remove(Object key) {
        this.values.remove(key);
    }

    public Object clone() {
        Map valueMap = (Map)ClassUtil.newInstance(this.values.getClass().getName());
        valueMap.putAll(this.values);
        DataObject dataobject = new DataObject(valueMap);
        dataobject.setKeySensitive(this.keySensitive);
        return dataobject;
    }

    public DataObject clone(String keys) {
        Map valueMap = (Map)ClassUtil.newInstance(this.values.getClass().getName());
        DataObject dataobject = new DataObject(valueMap);
        dataobject.setKeySensitive(this.keySensitive);
        if (this.values.isEmpty() || StringUtil.isEmpty(keys)) {
            return dataobject;
        }
        if (!this.keySensitive) {
            keys = keys.toUpperCase();
        }
        StringTokenizer stk = new StringTokenizer(keys, ",; ");
        while (stk.hasMoreTokens()) {
            String key = stk.nextToken().trim();
            if (!this.values.containsKey(key)) continue;
            valueMap.put(key, this.values.get(key));
        }
        return dataobject;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return this.values.toString();
    }
}

