/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.collection;

import com.tradevan.commons.CommonRuntimeException;
import com.tradevan.commons.collection.DataObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataList
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7603084418183315391L;
    private List list;

    public DataList() {
        this.list = new ArrayList();
    }

    public DataList(int initSize) {
        this.list = new ArrayList(initSize);
    }

    public DataList(List list) {
        this.list = list;
    }

    public void add(DataObject obj) {
        this.list.add(obj);
    }

    public void addAll(DataList list) {
        this.list.addAll(list.toList());
    }

    public DataObject get(int index) {
        if (index >= this.list.size()) {
            throw new CommonRuntimeException(String.valueOf(index) + " is out of range " + this.list.size());
        }
        return (DataObject)this.list.get(index);
    }

    public DataObject remove(int index) {
        if (index >= this.list.size()) {
            throw new CommonRuntimeException(String.valueOf(index) + " is out of range " + this.list.size());
        }
        return (DataObject)this.list.remove(index);
    }

    public boolean remove(DataObject obj) {
        return this.list.remove(obj);
    }

    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public List toList() {
        return this.list;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public DataObject[] toArray() {
        DataObject[] objs = new DataObject[this.list.size()];
        this.list.toArray(objs);
        return objs;
    }

    public Object clone() {
        DataList dataList = new DataList();
        dataList.addAll(this);
        return dataList;
    }

    public String toString() {
        return this.list.toString();
    }
}

