/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.collection;

import com.tradevan.commons.collection.ArrayUtil;
import com.tradevan.commons.lang.IntObject;
import com.tradevan.commons.util.Filter;
import com.tradevan.commons.util.Processor;
import com.tradevan.commons.util.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static void addAll(Collection collection, Enumeration enumeration) {
        if (collection != null && enumeration != null) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
    }

    public static void addAll(Collection collection, Iterator iterator) {
        if (collection != null && iterator != null) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
    }

    public static void addAll(Collection collection, Object[] objects) {
        if (collection != null && objects != null) {
            int i = 0;
            while (i < objects.length) {
                collection.add(objects[i]);
                ++i;
            }
        }
    }

    public static Map calculateFreq(Collection collection) {
        HashMap count = new HashMap();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            IntObject c = (IntObject)count.get(obj);
            if (c == null) {
                count.put(obj, new IntObject(1));
                continue;
            }
            c.increase();
        }
        return count;
    }

    public static boolean containAny(Collection collection1, Collection collection2) {
        if (collection1.size() < collection2.size()) {
            Iterator it = collection1.iterator();
            while (it.hasNext()) {
                if (!collection2.contains(it.next())) continue;
                return true;
            }
        } else {
            Iterator it = collection2.iterator();
            while (it.hasNext()) {
                if (!collection1.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection filter(Collection collection, Filter filter) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.filter(collection.iterator(), filter);
    }

    public static Collection filter(Iterator iterator, Filter filter) {
        if (iterator == null) {
            return null;
        }
        if (filter == null) {
            return CollectionUtil.toList(iterator);
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!filter.accept(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static Object[] filter(Object[] object, Filter filter) {
        if (object == null) {
            return null;
        }
        if (filter == null) {
            return object;
        }
        ArrayList<Object> list = new ArrayList<Object>(object.length);
        int i = 0;
        while (i < object.length) {
            if (filter.accept(object[i])) {
                list.add(object[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public static Object find(Collection collection, Filter filter) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.find(collection.iterator(), filter);
    }

    /*
     * Unable to fully structure code
     */
    public static Object find(Iterator iterator, Filter filter) {
        if (filter != null && iterator != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            object = iterator.next();
            if (!filter.accept(object)) continue;
            return object;
lbl6:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    public static Object find(Object[] object, Filter filter) {
        if (object == null || filter == null) {
            return null;
        }
        int i = 0;
        while (i < object.length) {
            if (filter.accept(object[i])) {
                return object[i];
            }
            ++i;
        }
        return null;
    }

    public static int indexOf(Collection collection, Collection targetCollection) {
        if (collection == null || targetCollection == null) {
            return -1;
        }
        int index = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (targetCollection.contains(it.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int indexOf(Collection collection, Object obj) {
        if (collection == null || obj == null) {
            return -1;
        }
        int index = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            if (obj.equals(it.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int indexOf(Collection collection, Object obj, int index) {
        if (collection == null || obj == null) {
            return -1;
        }
        if (index >= collection.size()) {
            throw new IllegalArgumentException("Out of index! " + index + " >= " + collection.size());
        }
        Object[] objects = collection.toArray();
        int i = index;
        while (i < objects.length) {
            if (obj.equals(objects[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Collection intersect(Collection collectionA, Collection collectionB) {
        if (collectionA == null || collectionB == null) {
            return null;
        }
        ArrayList list = new ArrayList(Math.min(collectionA.size(), collectionB.size()));
        Iterator it = collectionA.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!collectionB.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEqualCollection(Collection a, Collection b) {
        if (a.size() != b.size()) {
            return false;
        }
        Map mapA = CollectionUtil.calculateFreq(a);
        Map mapB = CollectionUtil.calculateFreq(b);
        if (mapA.size() != mapB.size()) {
            return false;
        }
        Iterator it = mapA.keySet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            IntObject times = (IntObject)mapA.get(obj);
            if (times.equals(mapB.get(obj))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubCollection(Collection collectionA, Collection collectionB) {
        if (collectionB.size() > collectionA.size()) {
            return false;
        }
        Map mapA = CollectionUtil.calculateFreq(collectionA);
        Map mapB = CollectionUtil.calculateFreq(collectionB);
        Iterator it = collectionA.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            IntObject timesA = (IntObject)mapA.get(obj);
            IntObject timesB = (IntObject)mapB.get(obj);
            if (timesB == null || timesB.intValue() <= timesA.intValue()) continue;
            return false;
        }
        return true;
    }

    public static Object max(Collection collection) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.max(collection.iterator());
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.max(collection.iterator(), comparator);
    }

    public static Object max(Iterator iterator) {
        if (iterator == null) {
            return null;
        }
        Comparable maxObject = null;
        if (iterator.hasNext()) {
            maxObject = (Comparable)iterator.next();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (maxObject.compareTo(obj) >= 0) continue;
                maxObject = (Comparable)obj;
            }
        }
        return maxObject;
    }

    public static Object max(Iterator iterator, Comparator comparator) {
        if (iterator == null || comparator == null) {
            return null;
        }
        Object maxObject = null;
        if (iterator.hasNext()) {
            maxObject = iterator.next();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (comparator.compare(maxObject, obj) >= 0) continue;
                maxObject = obj;
            }
        }
        return maxObject;
    }

    public static Object min(Collection collection) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.min(collection.iterator());
    }

    public static Object min(Collection collection, Comparator comparator) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.min(collection.iterator(), comparator);
    }

    public static Object min(Iterator iterator) {
        if (iterator == null) {
            return null;
        }
        Comparable minObject = null;
        if (iterator.hasNext()) {
            minObject = (Comparable)iterator.next();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (minObject.compareTo(obj) <= 0) continue;
                minObject = (Comparable)obj;
            }
        }
        return minObject;
    }

    public static Object min(Iterator iterator, Comparator comparator) {
        if (iterator == null || comparator == null) {
            return null;
        }
        Object minObject = null;
        if (iterator.hasNext()) {
            minObject = iterator.next();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (comparator.compare(minObject, obj) <= 0) continue;
                minObject = obj;
            }
        }
        return minObject;
    }

    public static void process(Collection collection, Processor processor) {
        if (collection != null && processor != null) {
            CollectionUtil.process(collection.iterator(), processor);
        }
    }

    public static void process(Iterator iterator, Processor processor) {
        if (iterator != null && processor != null) {
            while (iterator.hasNext()) {
                processor.execute(iterator.next());
            }
        }
    }

    public static void process(Object[] object, Processor processor) {
        if (object != null && processor != null) {
            int i = 0;
            while (i < object.length) {
                processor.execute(object[i]);
                ++i;
            }
        }
    }

    public static int removeAll(Collection collection, Collection remove) {
        int count = 0;
        if (collection != null && remove != null) {
            Iterator it = remove.iterator();
            while (it.hasNext()) {
                if (!collection.remove(it.next())) continue;
                ++count;
            }
        }
        return count;
    }

    public static int removeAll(Collection collection, Filter filter) {
        int count = 0;
        if (collection != null && filter != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (filter.accept(it.next())) continue;
                it.remove();
                ++count;
            }
        }
        return count;
    }

    public static int replaceAll(Collection collection, Object oldObject, Object newObject) {
        int count = 0;
        if (collection != null && oldObject != null && newObject != null) {
            ArrayList<Object> list = new ArrayList<Object>(collection);
            int i = 0;
            while (i < list.size()) {
                if (oldObject.equals(list.get(i))) {
                    list.set(i, newObject);
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public static Collection retainAll(Collection collection, Collection retain) {
        if (collection == null) {
            return null;
        }
        if (retain == null || retain.isEmpty()) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(Math.min(collection.size(), retain.size()));
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!retain.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static Collection subtract(Collection collectionA, Collection collectionB) {
        if (collectionA == null || collectionB == null) {
            return collectionA;
        }
        ArrayList list = new ArrayList(collectionA);
        Iterator it = collectionB.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static Object[] toArray(Collection collection) {
        if (collection == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return collection.toArray();
    }

    public static Object[] toArray(Enumeration enumeration) {
        if (enumeration == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return CollectionUtil.toList(enumeration).toArray();
    }

    public static Object[] toArray(Iterator iterator) {
        if (iterator == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return CollectionUtil.toList(iterator).toArray();
    }

    public static List toList(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList(collection);
    }

    public static List toList(Enumeration enumeration) {
        if (enumeration == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static List toList(Iterator iterator) {
        if (iterator == null) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static List toList(Object[] objects) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            list.add(objects[i]);
            ++i;
        }
        return list;
    }

    public static Collection transform(Collection collection, Transformer transformer) {
        if (collection == null) {
            return null;
        }
        return CollectionUtil.transform(collection.iterator(), transformer);
    }

    public static Collection transform(Iterator iterator, Transformer transformer) {
        if (iterator == null) {
            return null;
        }
        if (transformer == null) {
            return CollectionUtil.toList(iterator);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (iterator.hasNext()) {
            list.add(transformer.transform(iterator.next()));
        }
        return list;
    }

    public static Object[] transform(Object[] objects, Transformer transformer, boolean effectOriginal) {
        if (objects == null) {
            return null;
        }
        if (transformer == null) {
            return objects;
        }
        Object[] transObj = null;
        transObj = effectOriginal ? objects : new Object[objects.length];
        int i = 0;
        while (i < transObj.length) {
            transObj[i] = transformer.transform(objects[i]);
            ++i;
        }
        return transObj;
    }

    public static Collection union(Collection collectionA, Collection collectionB) {
        if (collectionA == null) {
            return collectionB;
        }
        ArrayList list = new ArrayList();
        list.addAll(collectionA);
        if (collectionB != null) {
            Iterator it = collectionB.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (list.contains(object)) continue;
                list.add(object);
            }
        }
        return list;
    }
}

