/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.commons.collection;

import com.tradevan.commons.collection.CollectionUtil;
import com.tradevan.commons.lang.IntObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] newArray = (boolean[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (boolean[])Array.newInstance(Boolean.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static byte[] add(byte[] array, byte element) {
        byte[] newArray = (byte[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (byte[])Array.newInstance(Byte.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static char[] add(char[] array, char element) {
        char[] newArray = (char[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (char[])Array.newInstance(Character.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static double[] add(double[] array, double element) {
        double[] newArray = (double[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (double[])Array.newInstance(Double.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static float[] add(float[] array, float element) {
        float[] newArray = (float[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (float[])Array.newInstance(Float.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static int[] add(int[] array, int element) {
        int[] newArray = (int[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null) {
            newArray = (int[])Array.newInstance(Integer.TYPE, 1);
        }
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static Object[] add(Object[] array, Object newObject) {
        Object[] newArray = (Object[])ArrayUtil.copyArrayGrow(array, 1);
        if (newArray == null && newObject != null) {
            newArray = (Object[])Array.newInstance(newObject.getClass(), 1);
        }
        newArray[newArray.length - 1] = newObject;
        return newArray;
    }

    public static boolean[] addAll(boolean[] array1, boolean[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (boolean[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (boolean[])array1.clone();
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static byte[] addAll(byte[] array1, byte[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (byte[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (byte[])array1.clone();
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static char[] addAll(char[] array1, char[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (char[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (char[])array1.clone();
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static double[] addAll(double[] array1, double[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (double[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (double[])array1.clone();
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static float[] addAll(float[] array1, float[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (float[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (float[])array1.clone();
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static int[] addAll(int[] array1, int[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (int[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (int[])array1.clone();
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null && array2 != null) {
            return (Object[])array2.clone();
        }
        if (array2 == null && array1 != null) {
            return (Object[])array1.clone();
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static double average(double[] num) {
        if (num == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (num.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double sum = 0.0;
        int i = 0;
        while (i < num.length) {
            sum += num[i];
            ++i;
        }
        return sum / (double)num.length;
    }

    public static float average(float[] num) {
        if (num == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (num.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double sum = 0.0;
        int i = 0;
        while (i < num.length) {
            sum += (double)num[i];
            ++i;
        }
        return (float)(sum / (double)num.length);
    }

    public static double average(int[] num) {
        if (num == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (num.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long sum = 0L;
        int i = 0;
        while (i < num.length) {
            sum += (long)num[i];
            ++i;
        }
        return sum / (long)num.length;
    }

    public static Map calculateFreq(Object[] objects) {
        HashMap<Object, IntObject> count = new HashMap<Object, IntObject>();
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            IntObject c = (IntObject)count.get(obj);
            if (c == null) {
                count.put(obj, new IntObject(1));
            } else {
                c.increase();
            }
            ++i;
        }
        return count;
    }

    public static boolean containAny(Object[] objects, Object[] objects1) {
        if (objects == null || objects1 == null) {
            return false;
        }
        List checkList = CollectionUtil.toList(objects1);
        int i = 0;
        while (i < objects.length) {
            if (checkList.contains(objects[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object copyArrayGrow(Object array, int n) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + n);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return null;
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static int indexOf(byte[] array, byte value) {
        return ArrayUtil.indexOf(array, value, 0);
    }

    public static int indexOf(byte[] array, byte value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char value) {
        return ArrayUtil.indexOf(array, value, 0);
    }

    public static int indexOf(char[] array, char value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double value) {
        return ArrayUtil.indexOf(array, value, 0);
    }

    public static int indexOf(double[] array, double value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float value) {
        return ArrayUtil.indexOf(array, value, 0);
    }

    public static int indexOf(float[] array, float value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int value) {
        return ArrayUtil.indexOf(array, value, 0);
    }

    public static int indexOf(int[] array, int value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object[] objects, Object object) {
        return ArrayUtil.indexOf(objects, object, 0);
    }

    public static int indexOf(Object[] array, Object value, int startIndex) {
        if (array == null || array.length == 0 || value == null || startIndex < 0) {
            return -1;
        }
        int i = startIndex;
        while (i < array.length) {
            if (value.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object[] objects, Object[] targetObject) {
        if (objects == null || targetObject == null) {
            return -1;
        }
        List target = CollectionUtil.toList(targetObject);
        int i = 0;
        while (i < objects.length) {
            if (target.contains(objects[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Object[] intersect(Object[] objects1, Object[] objects2) {
        if (objects1 == null || objects2 == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(Math.min(objects1.length, objects2.length));
        List list2 = CollectionUtil.toList(objects2);
        int i = 0;
        while (i < objects1.length) {
            if (list2.contains(objects1[i])) {
                list.add(objects1[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public static boolean isEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static boolean isSubArray(Object[] objects1, Object[] objects2) {
        if (objects1 == null || objects2 == null || objects2.length > objects1.length) {
            return false;
        }
        Map mapA = ArrayUtil.calculateFreq(objects1);
        Map mapB = ArrayUtil.calculateFreq(objects2);
        int i = 0;
        while (i < objects2.length) {
            Object obj = objects2[i];
            IntObject timesA = (IntObject)mapA.get(obj);
            IntObject timesB = (IntObject)mapB.get(obj);
            if (timesA == null || timesB.intValue() > timesA.intValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array, double value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array, float value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int value, int startIndex) {
        if (array == null || array.length == 0 || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (array[i] == value) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object value) {
        return ArrayUtil.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object value, int startIndex) {
        if (array == null || array.length == 0 || value == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (value.equals(array[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static byte max(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    public static char max(char[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        char max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
            }
            ++i;
        }
        return max;
    }

    public static double max(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double max = array[0];
        int j = 1;
        while (j < array.length) {
            if (array[j] > max) {
                max = array[j];
            }
            ++j;
        }
        return max;
    }

    public static float max(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max = array[0];
        int j = 1;
        while (j < array.length) {
            if (array[j] > max) {
                max = array[j];
            }
            ++j;
        }
        return max;
    }

    public static int max(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int max = array[0];
        int j = 1;
        while (j < array.length) {
            if (array[j] > max) {
                max = array[j];
            }
            ++j;
        }
        return max;
    }

    public static Object max(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Comparable maxObject = null;
        if (objects.length >= 1) {
            maxObject = (Comparable)objects[0];
            int i = 1;
            while (i < objects.length) {
                Object obj = objects[i];
                if (maxObject.compareTo(obj) < 0) {
                    maxObject = (Comparable)obj;
                }
                ++i;
            }
        }
        return maxObject;
    }

    public static Object max(Object[] objects, Comparator comparator) {
        if (objects == null || comparator == null) {
            return null;
        }
        Object maxObject = null;
        if (objects.length >= 1) {
            maxObject = (Comparable)objects[0];
            int i = 1;
            while (i < objects.length) {
                Object obj = objects[i];
                if (comparator.compare(maxObject, obj) < 0) {
                    maxObject = obj;
                }
                ++i;
            }
        }
        return maxObject;
    }

    public static byte min(byte[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        byte min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    public static char min(char[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        char min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    public static double min(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    public static float min(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
            }
            ++i;
        }
        return min;
    }

    public static int min(int[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        int min = array[0];
        int j = 1;
        while (j < array.length) {
            if (array[j] < min) {
                min = array[j];
            }
            ++j;
        }
        return min;
    }

    public static Object min(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Comparable maxObject = null;
        if (objects.length >= 1) {
            maxObject = (Comparable)objects[0];
            int i = 1;
            while (i < objects.length) {
                Object obj = objects[i];
                if (maxObject.compareTo(obj) > 0) {
                    maxObject = (Comparable)obj;
                }
                ++i;
            }
        }
        return maxObject;
    }

    public static Object min(Object[] objects, Comparator comparator) {
        if (objects == null || comparator == null) {
            return null;
        }
        Object maxObject = null;
        if (objects.length >= 1) {
            maxObject = (Comparable)objects[0];
            int i = 1;
            while (i < objects.length) {
                Object obj = objects[i];
                if (comparator.compare(maxObject, obj) > 0) {
                    maxObject = obj;
                }
                ++i;
            }
        }
        return maxObject;
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayUtil.remove((Object)array, index);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayUtil.remove((Object)array, index);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayUtil.remove((Object)array, index);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayUtil.remove((Object)array, index);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayUtil.remove((Object)array, index);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayUtil.remove((Object)array, index);
    }

    public static Object remove(Object array, int index) {
        if (array == null) {
            return null;
        }
        int length = ArrayUtil.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static Object[] remove(Object[] array, int index) {
        return (Object[])ArrayUtil.remove((Object)array, index);
    }

    public static Object[] removeAll(Object[] objects, Object[] remove) {
        if (objects == null) {
            return null;
        }
        if (remove == null) {
            return (Object[])objects.clone();
        }
        ArrayList<Object> list = new ArrayList<Object>(objects.length);
        List removeList = CollectionUtil.toList(remove);
        int i = 0;
        while (i < objects.length) {
            if (!removeList.contains(objects[i])) {
                list.add(objects[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public static byte[] removeElement(byte[] array, byte value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (byte[])array.clone() : null;
        }
        return (byte[])ArrayUtil.remove((Object)array, index);
    }

    public static char[] removeElement(char[] array, char value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (char[])array.clone() : null;
        }
        return (char[])ArrayUtil.remove((Object)array, index);
    }

    public static double[] removeElement(double[] array, double value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (double[])array.clone() : null;
        }
        return (double[])ArrayUtil.remove((Object)array, index);
    }

    public static float[] removeElement(float[] array, float value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (float[])array.clone() : null;
        }
        return (float[])ArrayUtil.remove((Object)array, index);
    }

    public static int[] removeElement(int[] array, int value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (int[])array.clone() : null;
        }
        return (int[])ArrayUtil.remove((Object)array, index);
    }

    public static Object[] removeElement(Object[] array, Object value) {
        int index = ArrayUtil.indexOf(array, value, 0);
        if (index == -1) {
            return array != null ? (Object[])array.clone() : null;
        }
        return (Object[])ArrayUtil.remove((Object)array, index);
    }

    public static int replaceAll(Object[] objects, Object oldObject, Object newObject) {
        int count = 0;
        if (objects != null && oldObject != null && newObject != null) {
            int i = 0;
            while (i < objects.length) {
                if (oldObject.equals(objects[i])) {
                    objects[i] = newObject;
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    public static Object[] retainAll(Object[] objects, Object[] retain) {
        if (objects == null) {
            return null;
        }
        if (retain == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        ArrayList<Object> list = new ArrayList<Object>(Math.min(objects.length, retain.length));
        List checkList = CollectionUtil.toList(retain);
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (checkList.contains(obj)) {
                list.add(obj);
            }
            ++i;
        }
        return list.toArray();
    }

    public static void reverse(boolean[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(byte[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(char[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(double[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(float[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(int[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(long[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(Object[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static void reverse(short[] array) {
        if (array == null || array.length == 0) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static boolean[] subarray(boolean[] array, int startIndex, int endIndex) {
        return (boolean[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static byte[] subarray(byte[] array, int startIndex, int endIndex) {
        return (byte[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static char[] subarray(char[] array, int startIndex, int endIndex) {
        return (char[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static double[] subarray(double[] array, int startIndex, int endIndex) {
        return (double[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static float[] subarray(float[] array, int startIndex, int endIndex) {
        return (float[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static int[] subarray(int[] array, int startIndex, int endIndex) {
        return (int[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static long[] subarray(long[] array, int startIndex, int endIndex) {
        return (long[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static Object subarray(Object array, int startIndex, int endIndex) {
        int arrayLen;
        if (array == null || startIndex > endIndex) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > (arrayLen = ArrayUtil.getLength(array))) {
            endIndex = arrayLen;
        }
        int newSize = endIndex - startIndex;
        Object subarray = Array.newInstance(array.getClass().getComponentType(), newSize);
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static Object[] subarray(Object[] array, int startIndex, int endIndex) {
        return (Object[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static short[] subarray(short[] array, int startIndex, int endIndex) {
        return (short[])ArrayUtil.subarray((Object)array, startIndex, endIndex);
    }

    public static Object[] subtract(Object[] objects1, Object[] objects2) {
        if (objects1 == null || objects2 == null) {
            return objects1;
        }
        List list = CollectionUtil.toList(objects1);
        int i = 0;
        while (i < objects2.length) {
            list.remove(objects2[i]);
            ++i;
        }
        return list.toArray();
    }

    public static Object[] union(Object[] objects1, Object[] objects2) {
        if (objects1 == null) {
            return objects2;
        }
        if (objects2 == null) {
            return objects1;
        }
        List list = CollectionUtil.toList(objects1);
        if (objects2 != null) {
            int i = 0;
            while (i < objects2.length) {
                if (!list.contains(objects2[i])) {
                    list.add(objects2[i]);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    public double sum(double[] num) {
        if (num == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (num.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double sum = 0.0;
        int i = 1;
        while (i < num.length) {
            sum += num[i];
            ++i;
        }
        return sum;
    }

    public long sum(int[] num) {
        if (num == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (num.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        long sum = 0L;
        int i = 1;
        while (i < num.length) {
            sum += (long)num[i];
            ++i;
        }
        return sum;
    }
}

