/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.io.StreamUtil;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.taurus.text.TextCondition;
import com.tradevan.taurus.text.TextException;
import com.tradevan.taurus.text.TextIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class TextWriter
extends TextIO {
    protected PrintWriter writer = null;
    private boolean nullToEmpty = true;

    public TextWriter(OutputStream out) {
        if (this.charset != null) {
            try {
                this.writer = new PrintWriter(new OutputStreamWriter(out, this.charset));
            }
            catch (Exception e) {
                this.writer = new PrintWriter(new OutputStreamWriter(out));
            }
        } else {
            this.writer = new PrintWriter(new OutputStreamWriter(out));
        }
    }

    public TextWriter(OutputStream out, String charset) throws UnsupportedEncodingException {
        this.writer = new PrintWriter(new OutputStreamWriter(out, charset));
    }

    public TextWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public TextWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public TextWriter(String file, boolean append) throws FileNotFoundException {
        this(new FileOutputStream(file, append));
    }

    public TextWriter(String file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), charset);
    }

    public TextWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public TextWriter(File file, boolean append) throws FileNotFoundException {
        this(new FileOutputStream(file, append));
    }

    public TextWriter(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileOutputStream(file), charset);
    }

    public void setNullToEmpty(boolean nullToEmpty) {
        this.nullToEmpty = nullToEmpty;
    }

    public boolean isNullToEmpty() {
        return this.nullToEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(Object line) throws TextException {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.writeLine(line, true);
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
    }

    public void writeLine(Collection collection, String separator) throws TextException {
        this.writeLine(StringUtil.join((Collection)collection, (String)separator));
    }

    public void writeLine(Object[] array, String separator) throws TextException {
        this.writeLine(StringUtil.join((Object[])array, (String)separator));
    }

    public void writeLines(Collection lines) throws TextException {
        this.writeLinesUntil(lines, null);
    }

    public void writeLines(Iterator iterator) throws TextException {
        this.writeLinesUntil(iterator, null);
    }

    public void writeLines(String[] lines) throws TextException {
        this.writeLinesUntil(lines, null);
    }

    public void writeLinesUntil(Collection lines, TextCondition condition) throws TextException {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        this.writeLinesUntil(lines.iterator(), condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLinesUntil(Iterator iterator, TextCondition condition) throws TextException {
        if (iterator == null) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                Object line = null;
                while (iterator.hasNext()) {
                    line = iterator.next();
                    if (condition != null && condition.accept(line)) break;
                    this.writeLine(line, true);
                }
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLinesUntil(String[] lines, TextCondition condition) throws TextException {
        if (lines == null || lines.length == 0) {
            return;
        }
        try {
            PrintWriter printWriter = this.writer;
            synchronized (printWriter) {
                String line = null;
                int i = 0;
                while (i < lines.length) {
                    line = lines[i];
                    if (condition != null && condition.accept(line)) break;
                    this.writeLine(line, true);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new TextException(e.getMessage());
        }
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        StreamUtil.close((Writer)this.writer);
    }

    public Writer getWriter() {
        return this.writer;
    }

    protected void writeLine(Object line, boolean useProcessor) throws IOException {
        if (useProcessor && this.processor != null) {
            if ((line = this.processor.process(line)) != null) {
                this.writer.println(line);
            }
        } else {
            if (line == null && this.nullToEmpty) {
                line = "";
            }
            this.writer.println(line);
        }
    }
}

