/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.collection.DataList;
import com.tradevan.commons.collection.DataObject;
import com.tradevan.commons.lang.StringUtil;
import com.tradevan.taurus.text.TextElement;
import com.tradevan.taurus.text.TextException;
import com.tradevan.taurus.text.TextProcessor;
import com.tradevan.taurus.text.TextRuntimeException;
import com.tradevan.taurus.text.TextWriter;
import java.util.Properties;

public class TextOutputer
extends TextProcessor {
    public static final String UNIT_BYTE = "byte";
    public static final String UNIT_CHAR = "char";
    private static final int _BYTE_MODE = 1;
    private static final int _CHAR_MODE = 2;
    private TextWriter writer;
    private TextElement[] textElements;
    private String separator = ",";
    private int unitMode = 1;

    public TextOutputer() {
    }

    public TextOutputer(TextWriter writer) {
        this.writer = writer;
    }

    public TextOutputer(TextWriter writer, TextElement[] elements) {
        this.writer = writer;
        this.textElements = elements;
    }

    public TextWriter getWriter() {
        return this.writer;
    }

    public void init(Properties prop) {
        String s = prop.getProperty("separator");
        if (s != null) {
            this.separator = s;
        }
        if (!StringUtil.isEmpty((String)(s = prop.getProperty("length-unit")))) {
            this.setLengthUnit(s);
        }
    }

    public String format(DataObject obj, TextElement[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            String value = "";
            if (elements[i] != null) {
                value = obj == null ? null : obj.getString(elements[i].getId());
                if (this.unitMode == 1 || value == null) {
                    sb.append(elements[i].format(value));
                } else {
                    int strLen;
                    int elementLen = elements[i].getLength();
                    if (elementLen <= (strLen = value.length())) {
                        sb.append(value.substring(0, elementLen));
                    } else {
                        String padding = elements[i].getPadding();
                        if (StringUtil.isEmpty((String)padding)) {
                            padding = " ";
                        }
                        String padStr = StringUtil.fillStr((String)padding, (int)(elementLen - strLen));
                        if ("left".equals(elements[i].getAlign())) {
                            sb.append(value).append(padStr);
                        } else {
                            sb.append(padStr).append(value);
                        }
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String getLengthUnit() {
        return this.unitMode == 1 ? UNIT_BYTE : UNIT_CHAR;
    }

    public String getSeparator() {
        return this.separator;
    }

    public TextElement[] getTextElements() {
        return this.textElements;
    }

    public String merge(DataObject obj, TextElement[] elements) {
        return this.merge(obj, elements, this.separator);
    }

    public String merge(DataObject obj, TextElement[] elements, String separator) {
        if (obj == null) {
            return null;
        }
        if (elements == null || elements.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (elements.length > 0) {
            Object value = null;
            if (elements[0] != null) {
                value = obj.getValue(elements[0].getId());
                if (value != null) {
                    sb.append(value);
                } else if (!StringUtil.isEmpty((String)elements[0].getDefaultValue())) {
                    sb.append(elements[0].getDefaultValue());
                }
            }
        }
        int i = 1;
        while (i < elements.length) {
            sb.append(separator);
            Object value = null;
            if (elements[i] != null) {
                value = obj.getValue(elements[i].getId());
                if (value != null) {
                    sb.append(value);
                } else if (!StringUtil.isEmpty((String)elements[i].getDefaultValue())) {
                    sb.append(elements[i].getDefaultValue());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public void output(DataList list, TextElement[] elements) throws TextException {
        if (this.writer == null) {
            throw new TextRuntimeException("TextWriter is null! Please set a TextWriter to TextOutput!");
        }
        int i = 0;
        while (i < list.size()) {
            DataObject obj = list.get(i);
            this.writer.writeLine(this.format(obj, elements));
            ++i;
        }
    }

    public String output(DataObject obj, TextElement[] elements) throws TextException {
        if (this.writer == null) {
            throw new TextRuntimeException("TextWriter is null! Please set a TextWriter to TextOutput!");
        }
        String line = this.format(obj, elements);
        this.writer.writeLine(line);
        return line;
    }

    public void outputMerge(DataList list, TextElement[] elements) throws TextException {
        this.outputMerge(list, elements, this.separator);
    }

    public void outputMerge(DataList list, TextElement[] elements, String separator) throws TextException {
        if (this.writer == null) {
            throw new TextRuntimeException("TextWriter is null! Please set a TextWriter to TextOutput!");
        }
        int i = 0;
        while (i < list.size()) {
            DataObject obj = list.get(i);
            this.writer.writeLine(this.merge(obj, elements, separator));
            ++i;
        }
    }

    public String outputMerge(DataObject obj, TextElement[] elements) throws TextException {
        return this.outputMerge(obj, elements, this.separator);
    }

    public String outputMerge(DataObject obj, TextElement[] elements, String separator) throws TextException {
        if (this.writer == null) {
            throw new TextRuntimeException("TextWriter is null! Please set a TextWriter to TextOutput!");
        }
        String line = this.merge(obj, elements, separator);
        this.writer.writeLine(line);
        return line;
    }

    public void setLengthUnit(String unit) {
        if (UNIT_CHAR.equalsIgnoreCase(unit)) {
            this.unitMode = 2;
        } else if (UNIT_BYTE.equalsIgnoreCase(unit)) {
            this.unitMode = 1;
        } else {
            throw new TextRuntimeException("unit must is one of UNIT_CHAR or UNIT_BYTE!");
        }
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setTextElements(TextElement[] textElements) {
        this.textElements = textElements;
    }

    public void setWriter(TextWriter writer) {
        this.writer = writer;
    }
}

