/*
 * Decompiled with CFR 0.152.
 */
package com.tradevan.taurus.text;

import com.tradevan.commons.lang.StringUtil;
import com.tradevan.taurus.text.TextRuntimeException;
import java.io.Serializable;

public class TextElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6316475616886999976L;
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";
    private String id;
    private String defaultValue = "";
    private String padding = " ";
    private String align = "left";
    private int length = -1;

    public TextElement() {
    }

    public TextElement(String id) {
        this.id = id;
    }

    public Object clone() {
        TextElement element = new TextElement(this.id);
        element.align = this.align;
        element.length = this.length;
        element.padding = this.padding;
        element.defaultValue = this.defaultValue;
        return element;
    }

    public String format(String str) {
        if (this.length > -1) {
            if (str == null) {
                str = this.defaultValue;
            }
            return StringUtil.alignStr((String)str, (int)this.length, (String)this.align, (String)this.padding);
        }
        if (str != null) {
            return str;
        }
        return this.defaultValue;
    }

    public String getAlign() {
        return this.align;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setAlign(String align) {
        if (ALIGN_LEFT.equalsIgnoreCase(align)) {
            this.align = ALIGN_LEFT;
        } else if (ALIGN_RIGHT.equalsIgnoreCase(align)) {
            this.align = ALIGN_RIGHT;
        } else {
            throw new TextRuntimeException("align parameter must be one of ALIGN_LEFT or ALIGN_RIGHT!");
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    public String toString() {
        return this.id;
    }
}

